import { __extends } from "tslib";
import { List } from "./List";
import * as $array from "./Array";
/**
 * A version of [[List]] to hold children of the [[Container]].
 *
 * @see {@link https://www.amcharts.com/docs/v5/concepts/common-elements/containers/} for more info
 */
var Children = /** @class */ (function (_super) {
    __extends(Children, _super);
    function Children(container) {
        var _this = _super.call(this) || this;
        Object.defineProperty(_this, "_disposed", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: false
        });
        Object.defineProperty(_this, "_container", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(_this, "_events", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        _this._container = container;
        _this._events = _this.events.onAll(function (change) {
            if (change.type === "clear") {
                $array.each(change.oldValues, function (x) {
                    _this._onRemoved(x);
                });
            }
            else if (change.type === "push") {
                _this._onInserted(change.newValue);
            }
            else if (change.type === "setIndex") {
                _this._onRemoved(change.oldValue);
                _this._onInserted(change.newValue, change.index);
            }
            else if (change.type === "insertIndex") {
                _this._onInserted(change.newValue, change.index);
            }
            else if (change.type === "removeIndex") {
                _this._onRemoved(change.oldValue);
            }
            else if (change.type === "moveIndex") {
                _this._onRemoved(change.value);
                _this._onInserted(change.value, change.newIndex);
            }
            else {
                throw new Error("Unknown IListEvent type");
            }
        });
        return _this;
    }
    Object.defineProperty(Children.prototype, "_onInserted", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (child, index) {
            child._setParent(this._container, true);
            var childrenDisplay = this._container._childrenDisplay;
            if (index === undefined) {
                childrenDisplay.addChild(child._display);
            }
            else {
                childrenDisplay.addChildAt(child._display, index);
            }
        }
    });
    Object.defineProperty(Children.prototype, "_onRemoved", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (child) {
            this._container._childrenDisplay.removeChild(child._display);
            this._container.markDirtyBounds();
            this._container.markDirty();
        }
    });
    /**
     * Returns `true` if obejct is disposed.
     */
    Object.defineProperty(Children.prototype, "isDisposed", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            return this._disposed;
        }
    });
    /**
     * Permanently dispose this object.
     */
    Object.defineProperty(Children.prototype, "dispose", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            if (!this._disposed) {
                this._disposed = true;
                this._events.dispose();
                $array.each(this.values, function (child) {
                    child.dispose();
                });
            }
        }
    });
    return Children;
}(List));
export { Children };
//# sourceMappingURL=Children.js.map