import { __extends } from "tslib";
import { Entity } from "./Entity";
import { Color } from "./Color";
/**
 * An object which holds list of colors and can generate new ones.
 *
 * @see {@link https://www.amcharts.com/docs/v5/concepts/colors-gradients-and-patterns/#Color_sets} for more info
 */
var ColorSet = /** @class */ (function (_super) {
    __extends(ColorSet, _super);
    function ColorSet() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    //protected _currentPass: number = 0;
    Object.defineProperty(ColorSet.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            // Applying themes because color set will not have parent
            _super.prototype._afterNewApplyThemes.call(this);
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(ColorSet.prototype, "generateColors", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this.setPrivate("currentPass", this.getPrivate("currentPass", 0) + 1);
            var pass = this.getPrivate("currentPass");
            var colors = this.get("colors", [this.get("baseColor", Color.fromHex(0xff0000))]);
            if (!this.getPrivate("numColors")) {
                this.setPrivate("numColors", colors.length);
            }
            //const len = colors.length;
            var len = this.getPrivate("numColors");
            //const start = len - this.getPrivate("numColors")!;
            var start = 0;
            var passOptions = this.get("passOptions");
            var reuse = this.get("reuse");
            for (var i = start; i < len; i++) {
                if (reuse) {
                    colors.push(colors[i]);
                }
                else {
                    var hsl = colors[i].toHSL();
                    var h = hsl.h + (passOptions.hue || 0) * pass;
                    while (h > 1)
                        h -= 1;
                    var s = hsl.s + (passOptions.saturation || 0) * pass;
                    //if (s > 1) s -= Math.floor(s);
                    if (s > 1)
                        s = 1;
                    if (s < 0)
                        s = 0;
                    var l = hsl.l + (passOptions.lightness || 0) * pass;
                    //if (l > 1) l -= Math.floor(l);
                    while (l > 1)
                        l -= 1;
                    colors.push(Color.fromHSL(h, s, l));
                }
            }
        }
    });
    /**
     * Returns a [[Color]] at specific index.
     *
     * If there's no color at this index, a new color is generated.
     *
     * @param   index  Index
     * @return         Color
     */
    Object.defineProperty(ColorSet.prototype, "getIndex", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (index) {
            var colors = this.get("colors", []);
            var saturation = this.get("saturation");
            if (index >= colors.length) {
                this.generateColors();
                return this.getIndex(index);
            }
            return saturation != null ? Color.saturate(colors[index], saturation) : colors[index];
        }
    });
    /**
     * Returns next [[Color]] in the list.
     *
     * If the list is out of colors, new ones are generated dynamically.
     */
    Object.defineProperty(ColorSet.prototype, "next", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var currentStep = this.getPrivate("currentStep", this.get("startIndex", 0));
            this.setPrivate("currentStep", currentStep + this.get("step", 1));
            return this.getIndex(currentStep);
        }
    });
    /**
     * Resets counter to the start of the list, so the next call for `next()` will
     * return the first color.
     */
    Object.defineProperty(ColorSet.prototype, "reset", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this.setPrivate("currentStep", this.get("startIndex", 0));
        }
    });
    Object.defineProperty(ColorSet, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "ColorSet"
    });
    Object.defineProperty(ColorSet, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Entity.classNames.concat([ColorSet.className])
    });
    return ColorSet;
}(Entity));
export { ColorSet };
//# sourceMappingURL=ColorSet.js.map