import { __extends } from "tslib";
/**
 * ============================================================================
 * IMPORTS
 * ============================================================================
 * @hidden
 */
import * as $array from "./Array";
/**
 * A base class for disposable objects.
 *
 * @ignore Exclude from docs
 */
var DisposerClass = /** @class */ (function () {
    /**
     * Constructor.
     */
    function DisposerClass() {
        /**
         * Is object disposed?
         */
        Object.defineProperty(this, "_disposed", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this._disposed = false;
    }
    /**
     * Checks if object is disposed.
     *
     * @return Disposed?
     */
    Object.defineProperty(DisposerClass.prototype, "isDisposed", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            return this._disposed;
        }
    });
    /**
     * Disposes the object.
     */
    Object.defineProperty(DisposerClass.prototype, "dispose", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            if (!this._disposed) {
                this._disposed = true;
                this._dispose();
            }
        }
    });
    return DisposerClass;
}());
export { DisposerClass };
/**
 * A class for creating an IDisposer.
 *
 * @ignore Exclude from docs
 */
var Disposer = /** @class */ (function () {
    /**
     * Constructor.
     *
     * @param dispose  Function that disposes object
     */
    function Disposer(dispose) {
        /**
         * Is object disposed?
         */
        Object.defineProperty(this, "_disposed", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        /**
         * Method that disposes the object.
         */
        Object.defineProperty(this, "_dispose", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        this._disposed = false;
        this._dispose = dispose;
    }
    /**
     * Checks if object is disposed.
     *
     * @return Disposed?
     */
    Object.defineProperty(Disposer.prototype, "isDisposed", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            return this._disposed;
        }
    });
    /**
     * Disposes the object.
     */
    Object.defineProperty(Disposer.prototype, "dispose", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            if (!this._disposed) {
                this._disposed = true;
                this._dispose();
            }
        }
    });
    return Disposer;
}());
export { Disposer };
/**
 * This can be extended by other classes to add a `_disposers` property.
 *
 * @ignore Exclude from docs
 */
var ArrayDisposer = /** @class */ (function (_super) {
    __extends(ArrayDisposer, _super);
    function ArrayDisposer() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        Object.defineProperty(_this, "_disposers", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: []
        });
        return _this;
    }
    Object.defineProperty(ArrayDisposer.prototype, "_dispose", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            $array.each(this._disposers, function (x) {
                x.dispose();
            });
        }
    });
    return ArrayDisposer;
}(DisposerClass));
export { ArrayDisposer };
/**
 * A collection of related disposers that can be disposed in one go.
 *
 * @ignore Exclude from docs
 */
var MultiDisposer = /** @class */ (function (_super) {
    __extends(MultiDisposer, _super);
    function MultiDisposer(disposers) {
        var _this = _super.call(this) || this;
        Object.defineProperty(_this, "_disposers", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        _this._disposers = disposers;
        return _this;
    }
    Object.defineProperty(MultiDisposer.prototype, "_dispose", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            $array.each(this._disposers, function (x) {
                x.dispose();
            });
        }
    });
    return MultiDisposer;
}(DisposerClass));
export { MultiDisposer };
/**
 * A special kind of Disposer that has attached value set.
 *
 * If a new value is set using `set()` method, the old disposer value is
 * disposed.
 *
 * @ignore Exclude from docs
 * @todo Description
 */
var MutableValueDisposer = /** @class */ (function (_super) {
    __extends(MutableValueDisposer, _super);
    function MutableValueDisposer() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * Current disposer.
         */
        Object.defineProperty(_this, "_disposer", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        /**
         * Current value.
         */
        Object.defineProperty(_this, "_value", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        return _this;
    }
    Object.defineProperty(MutableValueDisposer.prototype, "_dispose", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            if (this._disposer != null) {
                this._disposer.dispose();
                this._disposer = undefined;
            }
        }
    });
    /**
     * Returns current value.
     *
     * @return Value
     */
    Object.defineProperty(MutableValueDisposer.prototype, "get", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            return this._value;
        }
    });
    /**
     * Sets value and disposes previous disposer if it was set.
     *
     * @param value     New value
     * @param disposer  Disposer
     */
    Object.defineProperty(MutableValueDisposer.prototype, "set", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (value, disposer) {
            if (this._disposer != null) {
                this._disposer.dispose();
            }
            this._disposer = disposer;
            this._value = value;
        }
    });
    /**
     * Resets the disposer value.
     */
    Object.defineProperty(MutableValueDisposer.prototype, "reset", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this.set(undefined, undefined);
        }
    });
    return MutableValueDisposer;
}(DisposerClass));
export { MutableValueDisposer };
/**
 * @ignore Exclude from docs
 * @todo Description
 */
var CounterDisposer = /** @class */ (function (_super) {
    __extends(CounterDisposer, _super);
    function CounterDisposer() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * [_counter description]
         *
         * @todo Description
         */
        Object.defineProperty(_this, "_counter", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 0
        });
        return _this;
    }
    /**
     * [increment description]
     *
     * @todo Description
     */
    Object.defineProperty(CounterDisposer.prototype, "increment", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            // TODO throw an error if it is disposed
            ++this._counter;
            // TODO make this more efficient
            return new Disposer(function () {
                --_this._counter;
                if (_this._counter === 0) {
                    _this.dispose();
                }
            });
        }
    });
    return CounterDisposer;
}(Disposer));
export { CounterDisposer };
//# sourceMappingURL=Disposer.js.map