/** @ignore */ /** */
import * as $array from "./Array";
/**
 * @ignore
 */
var Native = /** @class */ (function () {
    function Native() {
        var _this = this;
        Object.defineProperty(this, "_observer", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "_targets", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: []
        });
        this._observer = new ResizeObserver(function (entries) {
            $array.each(entries, function (entry) {
                $array.each(_this._targets, function (x) {
                    if (x.target === entry.target) {
                        x.callback();
                    }
                });
            });
        });
    }
    Object.defineProperty(Native.prototype, "addTarget", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (target, callback) {
            this._observer.observe(target, { box: "content-box" });
            this._targets.push({ target: target, callback: callback });
        }
    });
    Object.defineProperty(Native.prototype, "removeTarget", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (target) {
            this._observer.unobserve(target);
            $array.keepIf(this._targets, function (x) {
                return x.target !== target;
            });
        }
    });
    return Native;
}());
/**
 * @ignore
 */
var Raf = /** @class */ (function () {
    function Raf() {
        Object.defineProperty(this, "_timer", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: null
        });
        Object.defineProperty(this, "_targets", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: []
        });
    }
    Object.defineProperty(Raf.prototype, "addTarget", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (target, callback) {
            var _this = this;
            if (this._timer === null) {
                var lastTime_1 = null;
                var loop_1 = function () {
                    var currentTime = Date.now();
                    if (lastTime_1 === null || currentTime > (lastTime_1 + Raf.delay)) {
                        lastTime_1 = currentTime;
                        $array.each(_this._targets, function (x) {
                            var newSize = x.target.getBoundingClientRect();
                            if (newSize.width !== x.size.width || newSize.height !== x.size.height) {
                                x.size = newSize;
                                x.callback();
                            }
                        });
                    }
                    if (_this._targets.length === 0) {
                        _this._timer = null;
                    }
                    else {
                        _this._timer = requestAnimationFrame(loop_1);
                    }
                };
                this._timer = requestAnimationFrame(loop_1);
            }
            // We start off with fake bounds so that sensor always kicks in
            //let size = target.getBoundingClientRect();
            var size = { width: 0, height: 0, left: 0, right: 0, top: 0, bottom: 0 };
            this._targets.push({ target: target, callback: callback, size: size });
        }
    });
    Object.defineProperty(Raf.prototype, "removeTarget", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (target) {
            $array.keepIf(this._targets, function (x) {
                return x.target !== target;
            });
            if (this._targets.length === 0) {
                if (this._timer !== null) {
                    cancelAnimationFrame(this._timer);
                    this._timer = null;
                }
            }
        }
    });
    Object.defineProperty(Raf, "delay", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: 200
    });
    return Raf;
}());
/**
 * @ignore
 */
var observer = null;
/**
 * @ignore
 */
function makeSensor() {
    if (observer === null) {
        if (typeof ResizeObserver !== "undefined") {
            observer = new Native();
        }
        else {
            observer = new Raf();
        }
    }
    return observer;
}
/**
 * @ignore
 */
var ResizeSensor = /** @class */ (function () {
    function ResizeSensor(element, callback) {
        Object.defineProperty(this, "_sensor", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "_element", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(this, "_disposed", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: false
        });
        this._sensor = makeSensor();
        this._element = element;
        this._sensor.addTarget(element, callback);
    }
    Object.defineProperty(ResizeSensor.prototype, "isDisposed", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            return this._disposed;
        }
    });
    Object.defineProperty(ResizeSensor.prototype, "dispose", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            if (!this._disposed) {
                this._disposed = true;
                this._sensor.removeTarget(this._element);
            }
        }
    });
    Object.defineProperty(ResizeSensor.prototype, "sensor", {
        get: function () {
            return this._sensor;
        },
        enumerable: false,
        configurable: true
    });
    return ResizeSensor;
}());
export { ResizeSensor };
//# sourceMappingURL=ResizeSensor.js.map