import { __awaiter, __extends, __generator } from "tslib";
import { Entity } from "../../core/util/Entity";
import { Container } from "../../core/render/Container";
import { Picture } from "../../core/render/Picture";
import * as $utils from "../../core/util/Utils";
import { p100 } from "../../core/util/Percent";
/**
 * A plugin that can be used to annotate charts.
 *
 * @see {@link https://www.amcharts.com/docs/v5/concepts/exporting/annotator/} for more info
 */
var Annotator = /** @class */ (function (_super) {
    __extends(Annotator, _super);
    function Annotator() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        Object.defineProperty(_this, "_container", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(_this, "_picture", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(_this, "_markerArea", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(_this, "_skipRender", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: false
        });
        return _this;
    }
    //public extraImages: Array<Root | IAnnotatorImageSource> = [];
    //public dataSources: any[] = [];
    Object.defineProperty(Annotator.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._afterNew.call(this);
            this._setRawDefault("layer", 1000);
            this._root.addDisposer(this);
        }
    });
    Object.defineProperty(Annotator.prototype, "_beforeChanged", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._beforeChanged.call(this);
            if (this.isDirty("markerState")) {
                this._renderState();
            }
        }
    });
    /**
     * Triggers annotation mode on the chart. This will display UI toolbars and
     * disable all interactions on the chart itself.
     */
    Object.defineProperty(Annotator.prototype, "open", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            return __awaiter(this, void 0, void 0, function () {
                var markerArea;
                var _this = this;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            // Delay this so that it's not knocked off by closing of the ExportingMenu
                            this.setTimeout(function () {
                                _this._root._renderer.interactionsEnabled = false;
                            }, 100);
                            return [4 /*yield*/, this.getMarkerArea()];
                        case 1:
                            markerArea = _a.sent();
                            markerArea.show();
                            this._picture.hide(0);
                            if (this.get("markerState")) {
                                markerArea.restoreState(this.get("markerState"));
                            }
                            return [2 /*return*/];
                    }
                });
            });
        }
    });
    Object.defineProperty(Annotator.prototype, "_renderState", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            return __awaiter(this, void 0, void 0, function () {
                var markerArea;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0: return [4 /*yield*/, this.getMarkerArea()];
                        case 1:
                            markerArea = _a.sent();
                            if (this.get("markerState")) {
                                this._skipRender = true;
                                markerArea.renderState(this.get("markerState"));
                            }
                            return [2 /*return*/];
                    }
                });
            });
        }
    });
    /**
     * Exists from annotation mode. All annotations remain visible on the chart.
     */
    Object.defineProperty(Annotator.prototype, "close", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            return __awaiter(this, void 0, void 0, function () {
                var markerArea;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0: return [4 /*yield*/, this.getMarkerArea()];
                        case 1:
                            markerArea = _a.sent();
                            markerArea.close();
                            return [2 /*return*/];
                    }
                });
            });
        }
    });
    /**
     * Exits from annotation mode. Any changes made during last session of the
     * annotation editing are cancelled.
     */
    Object.defineProperty(Annotator.prototype, "cancel", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            return __awaiter(this, void 0, void 0, function () {
                var markerArea;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            this._root._renderer.interactionsEnabled = true;
                            return [4 /*yield*/, this.getMarkerArea()];
                        case 1:
                            markerArea = _a.sent();
                            this._picture.show(0);
                            markerArea.cancel();
                            return [2 /*return*/];
                    }
                });
            });
        }
    });
    /**
     * All annotations are removed.
     */
    Object.defineProperty(Annotator.prototype, "clear", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this.set("markerState", undefined);
            if (this._picture) {
                this._picture.set("src", "");
            }
        }
    });
    Object.defineProperty(Annotator.prototype, "toggle", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            return __awaiter(this, void 0, void 0, function () {
                var markerArea;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0: return [4 /*yield*/, this.getMarkerArea()];
                        case 1:
                            markerArea = _a.sent();
                            if (markerArea.isOpen) {
                                this.close();
                            }
                            else {
                                this.open();
                            }
                            return [2 /*return*/];
                    }
                });
            });
        }
    });
    Object.defineProperty(Annotator.prototype, "dispose", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype.dispose.call(this);
            if (this._markerArea && this._markerArea.isOpen) {
                this._markerArea.close();
            }
        }
    });
    Object.defineProperty(Annotator.prototype, "_maybeInit", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            return __awaiter(this, void 0, void 0, function () {
                var markerjs2, canvas, markerArea;
                var _this = this;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            // Create layer canvas
                            if (!this._container) {
                                this._container = this._root.container.children.push(Container.new(this._root, {
                                    width: p100,
                                    height: p100,
                                    layer: this.get("layer"),
                                    interactiveChildren: false
                                }));
                                this._picture = this._container.children.push(Picture.new(this._root, {
                                    width: p100,
                                    height: p100
                                }));
                            }
                            if (!!this._markerArea) return [3 /*break*/, 2];
                            return [4 /*yield*/, this._getMarkerJS()];
                        case 1:
                            markerjs2 = _a.sent();
                            canvas = this._container._display.getCanvas();
                            markerArea = new markerjs2.MarkerArea(canvas);
                            //markerArea.renderTarget = canvas;
                            markerArea.uiStyleSettings.logoPosition = "right";
                            markerArea.uiStyleSettings.zIndex = 20;
                            markerArea.targetRoot = canvas.parentElement;
                            this._disposers.push($utils.addEventListener(markerArea, "close", function () {
                                _this._root._renderer.interactionsEnabled = true;
                                _this._picture.show(0);
                            }));
                            this._disposers.push($utils.addEventListener(markerArea, "render", function (event) {
                                var picture = _this._picture;
                                picture.set("src", event.dataUrl);
                                if (!_this._skipRender) {
                                    _this.set("markerState", event.state);
                                }
                                _this._skipRender = false;
                            }));
                            this._markerArea = markerArea;
                            _a.label = 2;
                        case 2: return [2 /*return*/];
                    }
                });
            });
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(Annotator.prototype, "_getMarkerJS", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            return __awaiter(this, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0: return [4 /*yield*/, import(/* webpackChunkName: "markerjs2" */ "markerjs2")];
                        case 1: return [2 /*return*/, _a.sent()];
                    }
                });
            });
        }
    });
    /**
     * An instance of MarkerJS's [[MarkerArea]].
     *
     * @see {@link https://markerjs.com/docs/getting-started} for more info
     * @return MarkerArea
     */
    Object.defineProperty(Annotator.prototype, "getMarkerArea", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            return __awaiter(this, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0: return [4 /*yield*/, this._maybeInit()];
                        case 1:
                            _a.sent();
                            return [2 /*return*/, this._markerArea];
                    }
                });
            });
        }
    });
    Object.defineProperty(Annotator, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "Annotator"
    });
    Object.defineProperty(Annotator, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Entity.classNames.concat([Annotator.className])
    });
    return Annotator;
}(Entity));
export { Annotator };
//# sourceMappingURL=Annotator.js.map