import { __extends } from "tslib";
import { Color } from "../core/util/Color";
import { Theme } from "../core/Theme";
/**
 * @ignore
 */
var DarkTheme = /** @class */ (function (_super) {
    __extends(DarkTheme, _super);
    function DarkTheme() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(DarkTheme.prototype, "setupDefaultRules", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype.setupDefaultRules.call(this);
            this.rule("InterfaceColors").setAll({
                stroke: Color.fromHex(0x000000),
                fill: Color.fromHex(0x2b2b2b),
                primaryButton: Color.lighten(Color.fromHex(0x6794dc), -0.2),
                primaryButtonHover: Color.lighten(Color.fromHex(0x6771dc), -0.2),
                primaryButtonDown: Color.lighten(Color.fromHex(0x68dc75), -0.2),
                primaryButtonActive: Color.lighten(Color.fromHex(0x68dc76), -0.2),
                primaryButtonText: Color.fromHex(0xffffff),
                primaryButtonStroke: Color.lighten(Color.fromHex(0x6794dc), -0.2),
                secondaryButton: Color.fromHex(0x3b3b3b),
                secondaryButtonHover: Color.lighten(Color.fromHex(0x3b3b3b), 0.1),
                secondaryButtonDown: Color.lighten(Color.fromHex(0x3b3b3b), 0.15),
                secondaryButtonActive: Color.lighten(Color.fromHex(0x3b3b3b), 0.2),
                secondaryButtonText: Color.fromHex(0xbbbbbb),
                secondaryButtonStroke: Color.lighten(Color.fromHex(0x3b3b3b), -0.2),
                grid: Color.fromHex(0xbbbbbb),
                background: Color.fromHex(0x000000),
                alternativeBackground: Color.fromHex(0xffffff),
                text: Color.fromHex(0xffffff),
                alternativeText: Color.fromHex(0x000000),
                disabled: Color.fromHex(0xadadad),
                positive: Color.fromHex(0x50b300),
                negative: Color.fromHex(0xb30000)
            });
        }
    });
    return DarkTheme;
}(Theme));
export { DarkTheme };
//# sourceMappingURL=DarkTheme.js.map