import { __extends } from "tslib";
import { FlowLink } from "./FlowLink";
import * as $math from "../../core/util/Math";
/**
 * A link element used in [[Chord]] chart.
 */
var ChordLink = /** @class */ (function (_super) {
    __extends(ChordLink, _super);
    function ChordLink() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        Object.defineProperty(_this, "_p0", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(_this, "_p1", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(_this, "_type", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        return _this;
    }
    Object.defineProperty(ChordLink.prototype, "getPoint", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (location) {
            if (this._p0 && this._p1) {
                if (this._type === "line") {
                    var p = $math.getPointOnLine(this._p0, this._p1, location);
                    return { x: p.x, y: p.y, angle: $math.getAngle(this._p0, this._p1) };
                }
                else {
                    var p0 = $math.getPointOnQuadraticCurve(this._p0, this._p1, { x: 0, y: 0 }, Math.max(0, location - 0.01));
                    var p1 = $math.getPointOnQuadraticCurve(this._p0, this._p1, { x: 0, y: 0 }, Math.min(1, location + 0.01));
                    var p = $math.getPointOnQuadraticCurve(this._p0, this._p1, { x: 0, y: 0 }, location);
                    return { x: p.x, y: p.y, angle: $math.getAngle(p0, p1) };
                }
            }
            return { x: 0, y: 0, angle: 0 };
        }
    });
    Object.defineProperty(ChordLink, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "ChordLink"
    });
    Object.defineProperty(ChordLink, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: FlowLink.classNames.concat([ChordLink.className])
    });
    return ChordLink;
}(FlowLink));
export { ChordLink };
//# sourceMappingURL=ChordLink.js.map