import { __extends } from "tslib";
import { ChordLink } from "./ChordLink";
import * as $utils from "../../core/util/Utils";
/**
 * A link element used in [[ChordDirected]] chart.
 */
var ChordLinkDirected = /** @class */ (function (_super) {
    __extends(ChordLinkDirected, _super);
    function ChordLinkDirected() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(ChordLinkDirected.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this._settings.themeTags = $utils.mergeTags(this._settings.themeTags, ["chord", "link", "directed"]);
            _super.prototype._afterNew.call(this);
        }
    });
    Object.defineProperty(ChordLinkDirected, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "ChordLinkDirected"
    });
    Object.defineProperty(ChordLinkDirected, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: ChordLink.classNames.concat([ChordLinkDirected.className])
    });
    return ChordLinkDirected;
}(ChordLink));
export { ChordLinkDirected };
//# sourceMappingURL=ChordLinkDirected.js.map