import { __extends } from "tslib";
import { FlowNodes } from "./FlowNodes";
import { Slice } from "../../core/render/Slice";
import { Template } from "../../core/util/Template";
import { ListTemplate } from "../../core/util/List";
import { RadialLabel } from "../../core/render/RadialLabel";
import * as $math from "../../core/util/Math";
/**
 * Holds instances of nodes for a [[Chord]] series.
 */
var ChordNodes = /** @class */ (function (_super) {
    __extends(ChordNodes, _super);
    function ChordNodes() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * List of label elements.
         *
         * @default new ListTemplate<RadialLabel>
         */
        Object.defineProperty(_this, "labels", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: new ListTemplate(Template.new({}), function () { return RadialLabel._new(_this._root, {}, [_this.labels.template]); })
        });
        /**
         * Related [[Chord]] series.
         */
        Object.defineProperty(_this, "flow", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(_this, "_dAngle", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 0
        });
        /**
         * List of slice elements.
         *
         * @default new ListTemplate<Slice>
         */
        Object.defineProperty(_this, "rectangles", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: new ListTemplate(Template.new({}), function () { return Slice._new(_this._root, { themeTags: ["shape"] }, [_this.rectangles.template]); })
        });
        return _this;
    }
    /**
     * @ignore
     */
    Object.defineProperty(ChordNodes.prototype, "makeNode", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            var _this = this;
            var node = _super.prototype.makeNode.call(this, dataItem, "chord");
            var slice = node.children.insertIndex(0, this.rectangles.make());
            dataItem.set("slice", slice);
            slice._setSoft("fill", dataItem.get("fill"));
            var label = this.labels.make();
            this.labels.push(label);
            label.addTag("flow");
            label.addTag("chord");
            label.addTag("node");
            node.children.push(label);
            dataItem.set("label", label);
            node.events.on("dragstart", function (e) {
                var point = _this.toLocal(e.point);
                var angle = $math.getAngle({ x: 0, y: 0 }, point);
                if (_this.flow) {
                    _this._dAngle = _this.flow.get("startAngle", 0) - angle;
                }
            });
            node.events.on("dragged", function (e) {
                var point = _this.toLocal(e.point);
                var angle = $math.getAngle({ x: 0, y: 0 }, point);
                node.setAll({ x: 0, y: 0 });
                if (_this.flow) {
                    _this.flow.set("startAngle", angle + _this._dAngle);
                }
            });
            label._setDataItem(dataItem);
            slice._setDataItem(dataItem);
            return node;
        }
    });
    Object.defineProperty(ChordNodes.prototype, "_positionBullet", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (bullet) {
            var sprite = bullet.get("sprite");
            if (sprite) {
                var dataItem = sprite.dataItem;
                if (dataItem) {
                    var sprite_1 = bullet.get("sprite");
                    if (sprite_1) {
                        var slice = dataItem.get("slice");
                        var locationX = bullet.get("locationX", 0.5);
                        var locationY = bullet.get("locationY", 0.5);
                        if (slice) {
                            var radius = slice.get("radius", 0);
                            var innerRadius = slice.get("innerRadius", 0);
                            var bulletRadius = innerRadius + (radius - innerRadius) * locationY;
                            var angle = slice.get("startAngle", 0) + slice.get("arc", 0) * locationX;
                            sprite_1.setAll({ x: bulletRadius * $math.cos(angle), y: bulletRadius * $math.sin(angle) });
                        }
                    }
                }
            }
        }
    });
    Object.defineProperty(ChordNodes, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "ChordNodes"
    });
    Object.defineProperty(ChordNodes, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: FlowNodes.classNames.concat([ChordNodes.className])
    });
    return ChordNodes;
}(FlowNodes));
export { ChordNodes };
//# sourceMappingURL=ChordNodes.js.map