import { __extends } from "tslib";
import { Template } from "../../core/util/Template";
import { ListTemplate } from "../../core/util/List";
import { FlowNodes } from "./FlowNodes";
import { RoundedRectangle } from "../../core/render/RoundedRectangle";
/**
 * Holds instances of nodes for a [[Sankey]] series.
 */
var SankeyNodes = /** @class */ (function (_super) {
    __extends(SankeyNodes, _super);
    function SankeyNodes() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * List of rectangle elements.
         *
         * @default new ListTemplate<RoundedRectangle>
         */
        Object.defineProperty(_this, "rectangles", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: new ListTemplate(Template.new({}), function () { return RoundedRectangle._new(_this._root, { themeTags: ["shape"] }, [_this.rectangles.template]); })
        });
        /**
         * Related [[Sankey]] series.
         */
        Object.defineProperty(_this, "flow", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        return _this;
    }
    /**
     * @ignore
     */
    Object.defineProperty(SankeyNodes.prototype, "makeNode", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            var flow = this.flow;
            var node = _super.prototype.makeNode.call(this, dataItem, "sankey");
            var rectangle = node.children.insertIndex(0, this.rectangles.make());
            this.rectangles.push(rectangle);
            rectangle._setSoft("fill", dataItem.get("fill"));
            dataItem.set("rectangle", rectangle);
            node.events.on("dragged", function () {
                var d3SankeyNode = node.dataItem.get("d3SankeyNode");
                if (d3SankeyNode) {
                    if (flow) {
                        if (flow.get("orientation") == "horizontal") {
                            d3SankeyNode.x0 = node.x();
                            d3SankeyNode.y0 = node.y();
                        }
                        else {
                            d3SankeyNode.x0 = node.y();
                            d3SankeyNode.y0 = node.x();
                        }
                        flow.updateSankey();
                    }
                }
            });
            var label = this.labels.make();
            this.labels.push(label);
            if (flow) {
                label.addTag(flow.get("orientation", ""));
            }
            node.children.push(label);
            dataItem.set("label", label);
            label._setDataItem(dataItem);
            rectangle._setDataItem(dataItem);
            return node;
        }
    });
    Object.defineProperty(SankeyNodes.prototype, "_positionBullet", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (bullet) {
            var sprite = bullet.get("sprite");
            if (sprite) {
                var dataItem = sprite.dataItem;
                if (dataItem) {
                    var sprite_1 = bullet.get("sprite");
                    if (sprite_1) {
                        var rectangle = dataItem.get("rectangle");
                        var node = dataItem.get("node");
                        var locationX = bullet.get("locationX", 0.5);
                        var locationY = bullet.get("locationY", 0.5);
                        if (rectangle) {
                            sprite_1.setAll({ x: node.x() + rectangle.width() * locationX, y: node.y() + rectangle.height() * locationY });
                        }
                    }
                }
            }
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(SankeyNodes.prototype, "disposeDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            _super.prototype.disposeDataItem.call(this, dataItem);
            var rectangle = dataItem.get("rectangle");
            if (rectangle) {
                this.rectangles.removeValue(rectangle);
                rectangle.dispose();
            }
        }
    });
    Object.defineProperty(SankeyNodes, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "SankeyNodes"
    });
    Object.defineProperty(SankeyNodes, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: FlowNodes.classNames.concat([SankeyNodes.className])
    });
    return SankeyNodes;
}(FlowNodes));
export { SankeyNodes };
//# sourceMappingURL=SankeyNodes.js.map