import { __extends } from "tslib";
import { HierarchyDefaultTheme } from "./HierarchyDefaultTheme";
import { Container } from "../../core/render/Container";
import { Label } from "../../core/render/Label";
import { RoundedRectangle } from "../../core/render/RoundedRectangle";
import { Template } from "../../core/util/Template";
import { ListTemplate } from "../../core/util/List";
import * as $utils from "../../core/util/Utils";
/**
 * Creates a breadcrumb navigation control.
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/hierarchy/breadcrumbs/} for more info
 * @important
 */
var BreadcrumbBar = /** @class */ (function (_super) {
    __extends(BreadcrumbBar, _super);
    function BreadcrumbBar() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * A list of labels in the bar.
         *
         * `labels.template` can be used to configure label apperance and behavior.
         *
         * @default new ListTemplate<Label>
         */
        Object.defineProperty(_this, "labels", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: new ListTemplate(Template.new({}), function () { return Label._new(_this._root, {
                themeTags: $utils.mergeTags(_this.labels.template.get("themeTags", []), ["label"]),
                background: RoundedRectangle.new(_this._root, {
                    themeTags: ["background"]
                })
            }, [_this.labels.template]); })
        });
        Object.defineProperty(_this, "_disposer", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        return _this;
    }
    /**
     * @ignore
     */
    Object.defineProperty(BreadcrumbBar.prototype, "makeLabel", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            var _this = this;
            var label = this.labels.make();
            label._setDataItem(dataItem);
            label.states.create("hover", {});
            label.states.create("down", {});
            label.events.on("click", function () {
                var series = _this.get("series");
                if (series) {
                    series.selectDataItem(dataItem);
                }
            });
            this.labels.push(label);
            return label;
        }
    });
    Object.defineProperty(BreadcrumbBar.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this._defaultThemes.push(HierarchyDefaultTheme.new(this._root));
            this._settings.themeTags = $utils.mergeTags(this._settings.themeTags, ["breadcrumb"]);
            _super.prototype._afterNew.call(this);
        }
    });
    Object.defineProperty(BreadcrumbBar.prototype, "_changed", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            _super.prototype._changed.call(this);
            if (this.isDirty("series")) {
                var series = this.get("series");
                var previous = this._prevSettings.series;
                if (series != previous) {
                    this._disposer = series.events.on("dataitemselected", function (event) {
                        _this._handleDataItem(event.dataItem);
                    });
                }
                else if (previous) {
                    if (this._disposer) {
                        this._disposer.dispose();
                    }
                }
                this._handleDataItem(series.get("selectedDataItem"));
            }
        }
    });
    Object.defineProperty(BreadcrumbBar.prototype, "_handleDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            this.set("minHeight", this.height());
            this.children.clear();
            this.labels.clear();
            if (dataItem) {
                var parent_1 = dataItem;
                while (parent_1) {
                    var label = this.makeLabel(parent_1);
                    if (parent_1 == dataItem) {
                        label.addTag("last");
                    }
                    this.children.moveValue(label, 0);
                    parent_1 = parent_1.get("parent");
                }
            }
        }
    });
    Object.defineProperty(BreadcrumbBar, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "BreadcrumbBar"
    });
    Object.defineProperty(BreadcrumbBar, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Container.classNames.concat([BreadcrumbBar.className])
    });
    return BreadcrumbBar;
}(Container));
export { BreadcrumbBar };
//# sourceMappingURL=BreadcrumbBar.js.map