import { __extends } from "tslib";
import { Graphics } from "../../core/render/Graphics";
import { geoLength, geoInterpolate, geoDistance } from "d3-geo";
/**
 * A line object in a [[MapLineSeries]].
 */
var MapLine = /** @class */ (function (_super) {
    __extends(MapLine, _super);
    function MapLine() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        Object.defineProperty(_this, "_projectionDirty", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: false
        });
        return _this;
    }
    Object.defineProperty(MapLine.prototype, "_beforeChanged", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            _super.prototype._beforeChanged.call(this);
            if (this._projectionDirty || this.isDirty("geometry") || this.isDirty("precision")) {
                var geometry_1 = this.get("geometry");
                if (geometry_1) {
                    var series_1 = this.getPrivate("series");
                    if (series_1) {
                        var chart = series_1.chart;
                        if (chart) {
                            var projection_1 = chart.get("projection");
                            var clipAngle_1 = null;
                            if (projection_1) {
                                clipAngle_1 = projection_1.clipAngle();
                                projection_1.precision(this.get("precision", 0.5));
                            }
                            var geoPath_1 = chart.getPrivate("geoPath");
                            if (geoPath_1) {
                                this._clear = true;
                                this.set("draw", function (_display) {
                                    if (projection_1 && series_1.get("clipBack") === false) {
                                        projection_1.clipAngle(180);
                                    }
                                    geoPath_1.context(_this._display);
                                    geoPath_1(geometry_1);
                                    geoPath_1.context(null);
                                    if (projection_1) {
                                        projection_1.clipAngle(clipAngle_1);
                                    }
                                });
                            }
                        }
                    }
                }
            }
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(MapLine.prototype, "markDirtyProjection", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this.markDirty();
            this._projectionDirty = true;
        }
    });
    Object.defineProperty(MapLine.prototype, "_clearDirty", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._clearDirty.call(this);
            this._projectionDirty = false;
        }
    });
    /**
     * Converts relative position along the line (0-1) into pixel coordinates.
     *
     * @param position  Position (0-1)
     * @return Coordinates
     */
    Object.defineProperty(MapLine.prototype, "positionToGeoPoint", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (position) {
            var geometry = this.get("geometry");
            if (geometry) {
                var totalDistance = geoLength(geometry);
                var currentDistance = 0;
                var distanceAB = void 0;
                var positionA = 0;
                var positionB = 0;
                var pointA = void 0;
                var pointB = void 0;
                var coordinates = geometry.coordinates;
                if (coordinates) {
                    var segments = void 0;
                    if (geometry.type == "LineString") {
                        segments = [coordinates];
                    }
                    else if (geometry.type == "MultiLineString") {
                        segments = coordinates;
                    }
                    for (var s = 0; s < segments.length; s++) {
                        var segment = segments[s];
                        if (segment.length > 1) {
                            for (var p = 1; p < segment.length; p++) {
                                pointA = segment[p - 1];
                                pointB = segment[p];
                                positionA = currentDistance / totalDistance;
                                distanceAB = geoDistance(pointA, pointB);
                                currentDistance += distanceAB;
                                positionB = currentDistance / totalDistance;
                                if (positionA <= position && positionB > position) {
                                    s = segments.length;
                                    break;
                                }
                            }
                        }
                        else if (segment.length == 1) {
                            pointA = segment[0];
                            ;
                            pointB = segment[0];
                            ;
                            positionA = 0;
                            positionB = 1;
                        }
                    }
                    if (pointA && pointB) {
                        var positionAB = (position - positionA) / (positionB - positionA);
                        var location_1 = geoInterpolate(pointA, pointB)(positionAB);
                        return { longitude: location_1[0], latitude: location_1[1] };
                    }
                }
            }
            return { longitude: 0, latitude: 0 };
        }
    });
    Object.defineProperty(MapLine, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "MapLine"
    });
    Object.defineProperty(MapLine, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Graphics.classNames.concat([MapLine.className])
    });
    return MapLine;
}(Graphics));
export { MapLine };
//# sourceMappingURL=MapLine.js.map