import { __extends } from "tslib";
import { MapSeries } from "./MapSeries";
import { MapLine } from "./MapLine";
import { ListTemplate } from "../../core/util/List";
import { Template } from "../../core/util/Template";
import * as $array from "../../core/util/Array";
/**
 * Creates a map series for displaying lines on the map.
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/map-chart/map-line-series/} for more info
 * @important
 */
var MapLineSeries = /** @class */ (function (_super) {
    __extends(MapLineSeries, _super);
    function MapLineSeries() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * A [[ListTemplate]] of all lines in series.
         *
         * `mapLines.template` can also be used to configure lines.
         *
         * @default new ListTemplate<MapLine>
         */
        Object.defineProperty(_this, "mapLines", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: new ListTemplate(Template.new({}), function () { return MapLine._new(_this._root, {}, [_this.mapLines.template]); })
        });
        Object.defineProperty(_this, "_types", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: ["LineString", "MultiLineString"]
        });
        return _this;
    }
    /**
     * @ignore
     */
    Object.defineProperty(MapLineSeries.prototype, "makeMapLine", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            var mapLine = this.children.push(this.mapLines.make());
            mapLine._setDataItem(dataItem);
            this.mapLines.push(mapLine);
            return mapLine;
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(MapLineSeries.prototype, "markDirtyProjection", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            $array.each(this.dataItems, function (dataItem) {
                var mapLine = dataItem.get("mapLine");
                if (mapLine) {
                    mapLine.markDirtyProjection();
                }
            });
        }
    });
    Object.defineProperty(MapLineSeries.prototype, "_prepareChildren", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._prepareChildren.call(this);
            if (this.isDirty("stroke")) {
                this.mapLines.template.set("stroke", this.get("stroke"));
            }
        }
    });
    Object.defineProperty(MapLineSeries.prototype, "processDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            var _this = this;
            _super.prototype.processDataItem.call(this, dataItem);
            var mapLine = dataItem.get("mapLine");
            if (!mapLine) {
                mapLine = this.makeMapLine(dataItem);
            }
            dataItem.set("mapLine", mapLine);
            var pointsToConnect = dataItem.get("pointsToConnect");
            if (pointsToConnect) {
                $array.each(pointsToConnect, function (point) {
                    point.on("geometry", function () {
                        _this.markDirtyValues(dataItem);
                    });
                    point.on("longitude", function () {
                        _this.markDirtyValues(dataItem);
                    });
                    point.on("latitude", function () {
                        _this.markDirtyValues(dataItem);
                    });
                });
                this.markDirtyValues(dataItem);
            }
            mapLine.setPrivate("series", this);
        }
    });
    /**
     * Forces a repaint of the element which relies on data.
     *
     * @since 5.0.21
     */
    Object.defineProperty(MapLineSeries.prototype, "markDirtyValues", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            _super.prototype.markDirtyValues.call(this);
            if (dataItem) {
                var mapLine = dataItem.get("mapLine");
                if (mapLine) {
                    var pointsToConnect = dataItem.get("pointsToConnect");
                    if (pointsToConnect) {
                        var coordinates_1 = [];
                        $array.each(pointsToConnect, function (point) {
                            var longitude = point.get("longitude");
                            var latitude = point.get("latitude");
                            if (longitude != null && latitude != null) {
                                coordinates_1.push([longitude, latitude]);
                            }
                            else {
                                var geometry_1 = point.get("geometry");
                                if (geometry_1) {
                                    var coords = geometry_1.coordinates;
                                    if (coords) {
                                        coordinates_1.push([coords[0], coords[1]]);
                                    }
                                }
                            }
                        });
                        var geometry = { type: "LineString", coordinates: coordinates_1 };
                        dataItem.setRaw("geometry", geometry);
                        mapLine.set("geometry", geometry);
                    }
                    else {
                        mapLine.set("geometry", dataItem.get("geometry"));
                    }
                }
            }
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(MapLineSeries.prototype, "disposeDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            _super.prototype.disposeDataItem.call(this, dataItem);
            var mapLine = dataItem.get("mapLine");
            if (mapLine) {
                this.mapLines.removeValue(mapLine);
                mapLine.dispose();
            }
        }
    });
    Object.defineProperty(MapLineSeries, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "MapLineSeries"
    });
    Object.defineProperty(MapLineSeries, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: MapSeries.classNames.concat([MapLineSeries.className])
    });
    return MapLineSeries;
}(MapSeries));
export { MapLineSeries };
//# sourceMappingURL=MapLineSeries.js.map