import { __extends } from "tslib";
import { MapSeries } from "./MapSeries";
import { MapPolygon } from "./MapPolygon";
import { Template } from "../../core/util/Template";
import { ListTemplate } from "../../core/util/List";
import * as $array from "../../core/util/Array";
import * as $mapUtils from "./MapUtils";
/**
 * Creates a map series for displaying polygons.
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/map-chart/map-polygon-series/} for more info
 * @important
 */
var MapPolygonSeries = /** @class */ (function (_super) {
    __extends(MapPolygonSeries, _super);
    function MapPolygonSeries() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * A [[ListTemplate]] of all polygons in series.
         *
         * `mapPolygons.template` can also be used to configure polygons.
         *
         * @default new ListTemplate<MapPolygon>
         */
        Object.defineProperty(_this, "mapPolygons", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: new ListTemplate(Template.new({}), function () { return MapPolygon._new(_this._root, {}, [_this.mapPolygons.template]); })
        });
        Object.defineProperty(_this, "_types", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: ["Polygon", "MultiPolygon"]
        });
        return _this;
    }
    /**
     * @ignore
     */
    Object.defineProperty(MapPolygonSeries.prototype, "makeMapPolygon", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            var mapPolygon = this.children.push(this.mapPolygons.make());
            mapPolygon._setDataItem(dataItem);
            this.mapPolygons.push(mapPolygon);
            return mapPolygon;
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(MapPolygonSeries.prototype, "markDirtyProjection", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            $array.each(this.dataItems, function (dataItem) {
                var mapPolygon = dataItem.get("mapPolygon");
                if (mapPolygon) {
                    mapPolygon.markDirtyProjection();
                }
            });
        }
    });
    Object.defineProperty(MapPolygonSeries.prototype, "_prepareChildren", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._prepareChildren.call(this);
            if (this.isDirty("fill")) {
                this.mapPolygons.template.set("fill", this.get("fill"));
            }
            if (this.isDirty("stroke")) {
                this.mapPolygons.template.set("stroke", this.get("stroke"));
            }
        }
    });
    Object.defineProperty(MapPolygonSeries.prototype, "processDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            _super.prototype.processDataItem.call(this, dataItem);
            var mapPolygon = dataItem.get("mapPolygon");
            if (!mapPolygon) {
                mapPolygon = this.makeMapPolygon(dataItem);
            }
            dataItem.set("mapPolygon", mapPolygon);
            var geometry = dataItem.get("geometry");
            if (geometry) {
                mapPolygon.set("geometry", geometry);
            }
            mapPolygon.series = this;
            this._addGeometry(dataItem.get("geometry"));
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(MapPolygonSeries.prototype, "disposeDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            _super.prototype.disposeDataItem.call(this, dataItem);
            var mapPolygon = dataItem.get("mapPolygon");
            if (mapPolygon) {
                this.mapPolygons.removeValue(mapPolygon);
                mapPolygon.dispose();
            }
            this._removeGeometry(dataItem.get("geometry"));
        }
    });
    /**
     * Forces a repaint of the element which relies on data.
     *
     * @since 5.0.21
     */
    Object.defineProperty(MapPolygonSeries.prototype, "markDirtyValues", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            _super.prototype.markDirtyValues.call(this);
            if (dataItem) {
                var mapPolygon = dataItem.get("mapPolygon");
                if (mapPolygon) {
                    mapPolygon.set("geometry", dataItem.get("geometry"));
                }
            }
        }
    });
    /**
     * Centers and zooms in on the specific polygon.
     *
     * @param  dataItem  Target data item
     * @see {@link https://www.amcharts.com/docs/v5/charts/map-chart/map-pan-zoom/#Zooming_to_clicked_object} for more info
     */
    Object.defineProperty(MapPolygonSeries.prototype, "zoomToDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            var polygon = dataItem.get("mapPolygon");
            if (polygon) {
                var geometry = polygon.get("geometry");
                var chart = this.chart;
                if (geometry && chart) {
                    return chart.zoomToGeoBounds($mapUtils.getGeoBounds(geometry));
                }
            }
        }
    });
    Object.defineProperty(MapPolygonSeries, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "MapPolygonSeries"
    });
    Object.defineProperty(MapPolygonSeries, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: MapSeries.classNames.concat([MapPolygonSeries.className])
    });
    return MapPolygonSeries;
}(MapSeries));
export { MapPolygonSeries };
//# sourceMappingURL=MapPolygonSeries.js.map