import { __extends } from "tslib";
import { Container } from "../../core/render/Container";
import { Button } from "../../core/render/Button";
import { Graphics } from "../../core/render/Graphics";
import { p100 } from "../../core/util/Percent";
import { MultiDisposer } from "../../core/util/Disposer";
/**
 * A control that displays button for zooming [[MapChart]] in and out.
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/map-chart/map-pan-zoom/#Zoom_control} for more information
 * @important
 */
var ZoomControl = /** @class */ (function (_super) {
    __extends(ZoomControl, _super);
    function ZoomControl() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * A [[Button]] for zoom in.
         *
         * @default Button.new()
         */
        Object.defineProperty(_this, "plusButton", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: _this.children.push(Button.new(_this._root, { width: 36, height: 36, themeTags: ["plus"] }))
        });
        /**
         * A [[Button]] for zoom out.
         *
         * @default Button.new()
         */
        Object.defineProperty(_this, "minusButton", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: _this.children.push(Button.new(_this._root, { width: 36, height: 36, themeTags: ["minus"] }))
        });
        Object.defineProperty(_this, "_disposer", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        return _this;
    }
    Object.defineProperty(ZoomControl.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._afterNew.call(this);
            this.set("position", "absolute");
            this.set("layout", this._root.verticalLayout);
            this.set("x", p100);
            this.set("centerX", p100);
            this.set("y", p100);
            this.set("centerY", p100);
            this.set("paddingRight", 10);
            this.set("paddingBottom", 10);
            this.plusButton.setAll({
                icon: Graphics.new(this._root, { themeTags: ["icon"] }),
                layout: undefined
            });
            this.minusButton.setAll({
                icon: Graphics.new(this._root, { themeTags: ["icon"] }),
                layout: undefined
            });
        }
    });
    Object.defineProperty(ZoomControl.prototype, "_prepareChildren", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._prepareChildren.call(this);
            if (this.isPrivateDirty("chart")) {
                var chart_1 = this.getPrivate("chart");
                var previous = this._prevPrivateSettings.chart;
                if (chart_1) {
                    this._disposer = new MultiDisposer([
                        this.plusButton.events.on("click", function () {
                            chart_1.zoomIn();
                        }),
                        this.minusButton.events.on("click", function () {
                            chart_1.zoomOut();
                        })
                    ]);
                }
                if (previous && this._disposer) {
                    this._disposer.dispose();
                }
            }
        }
    });
    Object.defineProperty(ZoomControl, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "ZoomControl"
    });
    Object.defineProperty(ZoomControl, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Container.classNames.concat([ZoomControl.className])
    });
    return ZoomControl;
}(Container));
export { ZoomControl };
//# sourceMappingURL=ZoomControl.js.map