import { __extends } from "tslib";
import { SerialChart } from "../../core/render/SerialChart";
import { PercentDefaultTheme } from "./PercentDefaultTheme";
/**
 * Base class for [[PieChart]].
 *
 * Also used for percent-based series, like [[FunnelSeries]], [[PyramidSeries]], etc.
 *
 * @important
 */
var PercentChart = /** @class */ (function (_super) {
    __extends(PercentChart, _super);
    function PercentChart() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(PercentChart.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this._defaultThemes.push(PercentDefaultTheme.new(this._root));
            _super.prototype._afterNew.call(this);
            this.chartContainer.children.push(this.seriesContainer);
            this.seriesContainer.children.push(this.bulletsContainer);
        }
    });
    Object.defineProperty(PercentChart, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "PercentChart"
    });
    Object.defineProperty(PercentChart, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: SerialChart.classNames.concat([PercentChart.className])
    });
    return PercentChart;
}(SerialChart));
export { PercentChart };
//# sourceMappingURL=PercentChart.js.map