import { __extends } from "tslib";
import { Percent } from "../../core/util/Percent";
import { PercentChart } from "../percent/PercentChart";
import { p50 } from "../../core/util/Percent";
import * as $utils from "../../core/util/Utils";
import * as $math from "../../core/util/Math";
/**
 * Creates a pie chart.
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/percent-charts/pie-chart/} for more info
 * @important
 */
var PieChart = /** @class */ (function (_super) {
    __extends(PieChart, _super);
    function PieChart() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        Object.defineProperty(_this, "_maxRadius", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 1
        });
        return _this;
    }
    Object.defineProperty(PieChart.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._afterNew.call(this);
            this.seriesContainer.setAll({ x: p50, y: p50 });
        }
    });
    Object.defineProperty(PieChart.prototype, "_prepareChildren", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._prepareChildren.call(this);
            var chartContainer = this.chartContainer;
            var w = chartContainer.innerWidth();
            var h = chartContainer.innerHeight();
            var startAngle = this.get("startAngle", 0);
            var endAngle = this.get("endAngle", 0);
            var innerRadius = this.get("innerRadius");
            var bounds = $math.getArcBounds(0, 0, startAngle, endAngle, 1);
            var wr = w / (bounds.right - bounds.left);
            var hr = h / (bounds.bottom - bounds.top);
            var innerBounds = { left: 0, right: 0, top: 0, bottom: 0 };
            if (innerRadius instanceof Percent) {
                var value = innerRadius.value;
                var mr = Math.min(wr, hr);
                value = Math.max(mr * value, mr - Math.min(h, w)) / mr;
                innerBounds = $math.getArcBounds(0, 0, startAngle, endAngle, value);
                this.setPrivateRaw("irModifyer", value / innerRadius.value);
            }
            bounds = $math.mergeBounds([bounds, innerBounds]);
            var prevRadius = this._maxRadius;
            this._maxRadius = Math.min(wr, hr);
            var radius = $utils.relativeToValue(this.get("radius", 0), this._maxRadius);
            this.seriesContainer.setAll({
                dy: -radius * (bounds.bottom + bounds.top) / 2, dx: -radius * (bounds.right + bounds.left) / 2
            });
            if (this.isDirty("startAngle") || this.isDirty("endAngle") || prevRadius != this._maxRadius) {
                this.series.each(function (series) {
                    series._markDirtyKey("startAngle");
                });
            }
        }
    });
    /**
     * Returns outer radius in pixels.
     *
     * If optional series parameter is passed in, it will return outer radius
     * of that particular series.
     *
     * @param   series  Series
     * @return          Radius in pixels
     */
    Object.defineProperty(PieChart.prototype, "radius", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (series) {
            var radius = $utils.relativeToValue(this.get("radius", 0), this._maxRadius);
            var innerRadius = $utils.relativeToValue(this.get("innerRadius", 0), radius);
            if (series) {
                var index = this.series.indexOf(series);
                var length_1 = this.series.length;
                var seriesRadius = series.get("radius");
                if (seriesRadius != null) {
                    return innerRadius + $utils.relativeToValue(seriesRadius, radius - innerRadius);
                }
                else {
                    return innerRadius + (radius - innerRadius) / length_1 * (index + 1);
                }
            }
            return radius;
        }
    });
    /**
     * Returns inner radius in pixels.
     *
     * If optional series parameter is passed in, it will return inner radius
     * of that particular series.
     *
     * @param   series  Series
     * @return          Radius in pixels
     */
    Object.defineProperty(PieChart.prototype, "innerRadius", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (series) {
            var radius = this.radius();
            var innerRadius = $utils.relativeToValue(this.get("innerRadius", 0), radius);
            if (innerRadius < 0) {
                innerRadius = radius + innerRadius;
            }
            if (series) {
                var index = this.series.indexOf(series);
                var length_2 = this.series.length;
                var seriesInnerRadius = series.get("innerRadius");
                if (seriesInnerRadius != null) {
                    return innerRadius + $utils.relativeToValue(seriesInnerRadius, radius - innerRadius);
                }
                else {
                    return innerRadius + (radius - innerRadius) / length_2 * index;
                }
            }
            return innerRadius;
        }
    });
    Object.defineProperty(PieChart, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "PieChart"
    });
    Object.defineProperty(PieChart, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: PercentChart.classNames.concat([PieChart.className])
    });
    return PieChart;
}(PercentChart));
export { PieChart };
//# sourceMappingURL=PieChart.js.map