import { __extends } from "tslib";
import { PercentSeries } from "../percent/PercentSeries";
import { Template } from "../../core/util/Template";
import { Slice } from "../../core/render/Slice";
import { Tick } from "../../core/render/Tick";
import { RadialLabel } from "../../core/render/RadialLabel";
import { ListTemplate } from "../../core/util/List";
import { p100 } from "../../core/util/Percent";
import * as $array from "../../core/util/Array";
import * as $math from "../../core/util/Math";
import * as $utils from "../../core/util/Utils";
/**
 * Creates a series for a [[PieChart]].
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/percent-charts/pie-chart/} for more info
 * @important
 */
var PieSeries = /** @class */ (function (_super) {
    __extends(PieSeries, _super);
    function PieSeries() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(PieSeries.prototype, "_makeSlices", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            return new ListTemplate(Template.new({}), function () { return Slice._new(_this._root, {
                themeTags: $utils.mergeTags(_this.slices.template.get("themeTags", []), ["pie", "series"])
            }, [_this.slices.template]); });
        }
    });
    Object.defineProperty(PieSeries.prototype, "_makeLabels", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            return new ListTemplate(Template.new({}), function () { return RadialLabel._new(_this._root, {
                themeTags: $utils.mergeTags(_this.labels.template.get("themeTags", []), ["pie", "series"])
            }, [_this.labels.template]); });
        }
    });
    Object.defineProperty(PieSeries.prototype, "_makeTicks", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            return new ListTemplate(Template.new({}), function () { return Tick._new(_this._root, {
                themeTags: $utils.mergeTags(_this.ticks.template.get("themeTags", []), ["pie", "series"])
            }, [_this.ticks.template]); });
        }
    });
    Object.defineProperty(PieSeries.prototype, "processDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            var _this = this;
            _super.prototype.processDataItem.call(this, dataItem);
            var slice = this.makeSlice(dataItem);
            slice.on("scale", function () {
                _this._updateTick(dataItem);
            });
            slice.on("shiftRadius", function () {
                _this._updateTick(dataItem);
            });
            slice.events.on("positionchanged", function () {
                _this._updateTick(dataItem);
            });
            var label = this.makeLabel(dataItem);
            label.events.on("positionchanged", function () {
                _this._updateTick(dataItem);
            });
            this.makeTick(dataItem);
            slice.events.on("positionchanged", function () {
                label.markDirty();
            });
        }
    });
    Object.defineProperty(PieSeries.prototype, "_getNextUp", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            return this.labelsContainer.maxHeight() / 2;
        }
    });
    Object.defineProperty(PieSeries.prototype, "_getNextDown", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            return -this.labelsContainer.maxHeight() / 2;
        }
    });
    Object.defineProperty(PieSeries.prototype, "_prepareChildren", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            _super.prototype._prepareChildren.call(this);
            var chart = this.chart;
            if (chart) {
                if (this.isDirty("alignLabels")) {
                    var labelsTemplate = this.labels.template;
                    if (this.get("alignLabels")) {
                        labelsTemplate.set("textType", "aligned");
                    }
                    else {
                        if (labelsTemplate.get("textType") == null) {
                            labelsTemplate.set("textType", "adjusted");
                        }
                    }
                }
                if (this._valuesDirty || this.isDirty("radius") || this.isDirty("innerRadius") || this.isDirty("startAngle") || this.isDirty("endAngle")) {
                    this.markDirtyBounds();
                    var startAngle = this.get("startAngle", chart.get("startAngle", -90));
                    var endAngle = this.get("endAngle", chart.get("endAngle", 270));
                    var arc_1 = endAngle - startAngle;
                    var currentAngle_1 = startAngle;
                    var radius_1 = chart.radius(this);
                    this.setPrivateRaw("radius", radius_1);
                    var innerRadius_1 = chart.innerRadius(this) * chart.getPrivate("irModifyer", 1);
                    if (innerRadius_1 < 0) {
                        innerRadius_1 = radius_1 + innerRadius_1;
                    }
                    if (radius_1 > 0) {
                        $array.each(this._dataItems, function (dataItem) {
                            _this.updateLegendValue(dataItem);
                            var currentArc = arc_1 * dataItem.get("valuePercentTotal") / 100;
                            var slice = dataItem.get("slice");
                            if (slice) {
                                slice.set("radius", radius_1);
                                slice.set("innerRadius", innerRadius_1);
                                slice.set("startAngle", currentAngle_1);
                                slice.set("arc", currentArc);
                                var color = dataItem.get("fill");
                                slice._setDefault("fill", color);
                                slice._setDefault("stroke", color);
                            }
                            var middleAngle = $math.normalizeAngle(currentAngle_1 + currentArc / 2);
                            var label = dataItem.get("label");
                            if (label) {
                                label.setPrivate("radius", radius_1);
                                label.setPrivate("innerRadius", innerRadius_1);
                                label.set("labelAngle", middleAngle);
                                if (label.get("textType") == "aligned") {
                                    var labelRadius = radius_1 + label.get("radius", 0);
                                    var y = radius_1 * $math.sin(middleAngle);
                                    if (middleAngle > 90 && middleAngle <= 270) {
                                        if (!label.isHidden() && !label.isHiding()) {
                                            _this._lLabels.push({ label: label, y: y });
                                        }
                                        labelRadius *= -1;
                                        labelRadius -= _this.labelsContainer.get("paddingLeft", 0);
                                        label.set("centerX", p100);
                                        label.setPrivateRaw("left", true);
                                    }
                                    else {
                                        if (!label.isHidden() && !label.isHiding()) {
                                            _this._rLabels.push({ label: label, y: y });
                                        }
                                        labelRadius += _this.labelsContainer.get("paddingRight", 0);
                                        label.set("centerX", 0);
                                        label.setPrivateRaw("left", false);
                                    }
                                    label.set("x", labelRadius);
                                    label.set("y", radius_1 * $math.sin(middleAngle));
                                }
                            }
                            currentAngle_1 += currentArc;
                            _this._updateTick(dataItem);
                        });
                    }
                }
            }
        }
    });
    Object.defineProperty(PieSeries.prototype, "_updateTick", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            var tick = dataItem.get("tick");
            var label = dataItem.get("label");
            var slice = dataItem.get("slice");
            var location = tick.get("location", 1);
            if (tick && label && slice) {
                var radius = (slice.get("shiftRadius", 0) + slice.get("radius", 0)) * slice.get("scale", 1) * location;
                var labelAngle = label.get("labelAngle", 0);
                var cos = $math.cos(labelAngle);
                var sin = $math.sin(labelAngle);
                var labelsContainer = this.labelsContainer;
                var pl = labelsContainer.get("paddingLeft", 0);
                var pr = labelsContainer.get("paddingRight", 0);
                var x = 0;
                var y = 0;
                x = label.x();
                y = label.y();
                if (label.get("textType") == "circular") {
                    var labelRadius = label.radius() - label.get("paddingBottom", 0);
                    var labelAngle_1 = label.get("labelAngle", 0);
                    x = labelRadius * $math.cos(labelAngle_1);
                    y = labelRadius * $math.sin(labelAngle_1);
                }
                var dx = -pr;
                if (label.getPrivate("left")) {
                    dx = pl;
                }
                tick.set("points", [{ x: slice.x() + radius * cos, y: slice.y() + radius * sin }, { x: x + dx, y: y }, { x: x, y: y }]);
            }
        }
    });
    Object.defineProperty(PieSeries, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "PieSeries"
    });
    Object.defineProperty(PieSeries, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: PercentSeries.classNames.concat([PieSeries.className])
    });
    return PieSeries;
}(PercentSeries));
export { PieSeries };
//# sourceMappingURL=PieSeries.js.map