import { __extends, __read } from "tslib";
import { AxisRenderer } from "../xy/axes/AxisRenderer";
import { p100 } from "../../core/util/Percent";
import { AxisLabelRadial } from "../xy/axes/AxisLabelRadial";
import { arc } from "d3-shape";
import { ListTemplate } from "../../core/util/List";
import { Template } from "../../core/util/Template";
import * as $utils from "../../core/util/Utils";
import * as $type from "../../core/util/Type";
import * as $math from "../../core/util/Math";
/**
 * Renderer for radial axes.
 */
var AxisRendererRadial = /** @class */ (function (_super) {
    __extends(AxisRendererRadial, _super);
    function AxisRendererRadial() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        Object.defineProperty(_this, "_fillGenerator", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: arc()
        });
        /**
         * A [[TemplateList]] with all the labels attached to the axis.
         *
         * `labels.template` can be used to configure appearance of the labels.
         *
         * @default new ListTemplate<AxisLabelRadial>
         */
        Object.defineProperty(_this, "labels", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: new ListTemplate(Template.new({}), function () { return AxisLabelRadial._new(_this._root, {
                themeTags: $utils.mergeTags(_this.labels.template.get("themeTags", []), _this.get("themeTags", []))
            }, [_this.labels.template]); })
        });
        return _this;
    }
    Object.defineProperty(AxisRendererRadial.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this._settings.themeTags = $utils.mergeTags(this._settings.themeTags, ["renderer", "radial"]);
            _super.prototype._afterNew.call(this);
            this.setPrivate("letter", "Y");
            this.setRaw("position", "absolute");
        }
    });
    Object.defineProperty(AxisRendererRadial.prototype, "_changed", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._changed.call(this);
            if (this.isDirty("radius") || this.isDirty("innerRadius") || this.isDirty("startAngle") || this.isDirty("endAngle")) {
                this.updateLayout();
            }
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(AxisRendererRadial.prototype, "processAxis", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype.processAxis.call(this);
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(AxisRendererRadial.prototype, "updateLayout", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var chart = this.chart;
            if (chart) {
                var radius = chart.getPrivate("radius", 0);
                var r_1 = $utils.relativeToValue(this.get("radius", p100), radius);
                var ir_1 = $utils.relativeToValue(this.get("innerRadius", chart.getPrivate("innerRadius", 0)), radius) * chart.getPrivate("irModifyer", 1);
                if (ir_1 < 0) {
                    ir_1 = r_1 + ir_1;
                }
                this.setPrivate("radius", r_1);
                this.setPrivate("innerRadius", ir_1);
                var startAngle = this.get("startAngle", chart.get("startAngle", -90));
                var endAngle = this.get("endAngle", chart.get("endAngle", 270));
                this.setPrivate("startAngle", startAngle);
                this.setPrivate("endAngle", endAngle);
                var axisAngle_1 = this.get("axisAngle", 0);
                this.set("draw", function (display) {
                    display.moveTo(ir_1 * $math.cos(axisAngle_1), ir_1 * $math.sin(axisAngle_1));
                    display.lineTo(r_1 * $math.cos(axisAngle_1), r_1 * $math.sin(axisAngle_1));
                });
                this.axis.markDirtySize();
            }
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(AxisRendererRadial.prototype, "updateGrid", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (grid, position, endPosition) {
            var _this = this;
            if (grid) {
                if (!$type.isNumber(position)) {
                    position = 0;
                }
                var location_1 = grid.get("location", 0.5);
                if ($type.isNumber(endPosition) && endPosition != position) {
                    position = position + (endPosition - position) * location_1;
                }
                var radius_1 = this.positionToCoordinate(position) + this.getPrivate("innerRadius", 0);
                this.toggleVisibility(grid, position, 0, 1);
                if ($type.isNumber(radius_1)) {
                    grid.set("draw", function (display) {
                        var startAngle = _this.getPrivate("startAngle", 0) * $math.RADIANS;
                        var endAngle = _this.getPrivate("endAngle", 0) * $math.RADIANS;
                        display.arc(0, 0, Math.max(0, radius_1), Math.min(startAngle, endAngle), Math.max(startAngle, endAngle));
                    });
                }
            }
        }
    });
    // do not delete
    Object.defineProperty(AxisRendererRadial.prototype, "_handleOpposite", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () { }
    });
    /**
     * Converts relative position to X/Y point.
     *
     * @param   position  Position
     * @return            Point
     */
    Object.defineProperty(AxisRendererRadial.prototype, "positionToPoint", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (position) {
            var innerRadius = this.getPrivate("innerRadius", 0);
            var radius = this.positionToCoordinate(position) + innerRadius;
            var axisAngle = this.get("axisAngle", 0);
            return { x: radius * $math.cos(axisAngle), y: radius * $math.sin(axisAngle) };
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(AxisRendererRadial.prototype, "updateLabel", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (label, position, endPosition, count) {
            if (label) {
                if (!$type.isNumber(position)) {
                    position = 0;
                }
                var location_2 = 0.5;
                if ($type.isNumber(count) && count > 1) {
                    location_2 = label.get("multiLocation", location_2);
                }
                else {
                    location_2 = label.get("location", location_2);
                }
                if ($type.isNumber(endPosition) && endPosition != position) {
                    position = position + (endPosition - position) * location_2;
                }
                var point = this.positionToPoint(position);
                var radius = Math.hypot(point.x, point.y);
                label.setPrivate("radius", radius);
                label.setPrivate("innerRadius", radius);
                label.set("labelAngle", this.get("axisAngle"));
                this.toggleVisibility(label, position, label.get("minPosition", 0), label.get("maxPosition", 1));
            }
        }
    });
    Object.defineProperty(AxisRendererRadial.prototype, "fillDrawMethod", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (fill, y0, y1) {
            var _this = this;
            fill.set("draw", function (display) {
                var _a;
                y0 = Math.max(0, y0);
                y1 = Math.max(0, y1);
                _this._fillGenerator.context(display);
                var startAngle = (_this.getPrivate("startAngle", 0) + 90) * $math.RADIANS;
                var endAngle = (_this.getPrivate("endAngle", 0) + 90) * $math.RADIANS;
                if (endAngle < startAngle) {
                    _a = __read([endAngle, startAngle], 2), startAngle = _a[0], endAngle = _a[1];
                }
                _this._fillGenerator({ innerRadius: y0, outerRadius: y1, startAngle: startAngle, endAngle: endAngle });
            });
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(AxisRendererRadial.prototype, "updateTick", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (tick, position, endPosition, count) {
            if (tick) {
                if (!$type.isNumber(position)) {
                    position = 0;
                }
                var location_3 = 0.5;
                if ($type.isNumber(count) && count > 1) {
                    location_3 = tick.get("multiLocation", location_3);
                }
                else {
                    location_3 = tick.get("location", location_3);
                }
                if ($type.isNumber(endPosition) && endPosition != position) {
                    position = position + (endPosition - position) * location_3;
                }
                var point = this.positionToPoint(position);
                tick.set("x", point.x);
                tick.set("y", point.y);
                var length_1 = tick.get("length", 0);
                var inside = tick.get("inside");
                if (inside) {
                    length_1 *= -1;
                }
                var axisAngle_2 = this.get("axisAngle", 0) + 90;
                tick.set("draw", function (display) {
                    display.moveTo(0, 0);
                    display.lineTo(length_1 * $math.cos(axisAngle_2), length_1 * $math.sin(axisAngle_2));
                });
                this.toggleVisibility(tick, position, tick.get("minPosition", 0), tick.get("maxPosition", 1));
            }
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(AxisRendererRadial.prototype, "updateBullet", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (bullet, position, endPosition) {
            if (bullet) {
                var sprite = bullet.get("sprite");
                if (sprite) {
                    if (!$type.isNumber(position)) {
                        position = 0;
                    }
                    var location_4 = bullet.get("location", 0.5);
                    if ($type.isNumber(endPosition) && endPosition != position) {
                        position = position + (endPosition - position) * location_4;
                    }
                    var point = this.positionToPoint(position);
                    sprite.setAll({ x: point.x, y: point.y });
                    this.toggleVisibility(sprite, position, 0, 1);
                }
            }
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(AxisRendererRadial.prototype, "updateFill", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (fill, position, endPosition) {
            if (fill) {
                if (!$type.isNumber(position)) {
                    position = 0;
                }
                if (!$type.isNumber(endPosition)) {
                    endPosition = 1;
                }
                var innerRadius = this.getPrivate("innerRadius", 0);
                var y0 = this.positionToCoordinate(position) + innerRadius;
                var y1 = this.positionToCoordinate(endPosition) + innerRadius;
                this.fillDrawMethod(fill, y0, y1);
            }
        }
    });
    /**
     * Returns axis length in pixels.
     *
     * @return Length
     */
    Object.defineProperty(AxisRendererRadial.prototype, "axisLength", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            return this.getPrivate("radius", 0) - this.getPrivate("innerRadius", 0);
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(AxisRendererRadial.prototype, "updateTooltipBounds", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (_tooltip) {
        }
    });
    /**
     * Converts relative position to pixels.
     *
     * @param   position  Position
     * @return            Pixels
     */
    Object.defineProperty(AxisRendererRadial.prototype, "positionToCoordinate", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (position) {
            if (this._inversed) {
                position = Math.min(this._end, position);
                return (this._end - position) * this._axisLength;
            }
            else {
                position = Math.max(this._start, position);
                return (position - this._start) * this._axisLength;
            }
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(AxisRendererRadial.prototype, "positionTooltip", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (tooltip, position) {
            var radius = this.getPrivate("innerRadius", 0) + this.positionToCoordinate(position);
            var angle = this.get("axisAngle", 0);
            //return tooltip.set("pointTo", this.axis._display.toGlobal({ x: radius * $math.cos(angle), y: radius * $math.sin(angle) }));
            this._positionTooltip(tooltip, { x: radius * $math.cos(angle), y: radius * $math.sin(angle) });
        }
    });
    Object.defineProperty(AxisRendererRadial, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "AxisRendererRadial"
    });
    Object.defineProperty(AxisRendererRadial, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: AxisRenderer.classNames.concat([AxisRendererRadial.className])
    });
    return AxisRendererRadial;
}(AxisRenderer));
export { AxisRendererRadial };
//# sourceMappingURL=AxisRendererRadial.js.map