import { __extends } from "tslib";
import { Theme } from "../../core/Theme";
import { p50, p100 } from "../../core/util/Percent";
import { ColorSet } from "../../core/util/ColorSet";
/**
 * @ignore
 */
var VennDefaultTheme = /** @class */ (function (_super) {
    __extends(VennDefaultTheme, _super);
    function VennDefaultTheme() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(VennDefaultTheme.prototype, "setupDefaultRules", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype.setupDefaultRules.call(this);
            var r = this.rule.bind(this);
            r("Venn").setAll({
                legendLabelText: "{category}",
                legendValueText: "{value}",
                colors: ColorSet.new(this._root, {}),
                width: p100,
                height: p100
            });
            r("Label", ["venn"]).setAll({
                text: "{category}",
                populateText: true,
                centerX: p50,
                centerY: p50
            });
        }
    });
    return VennDefaultTheme;
}(Theme));
export { VennDefaultTheme };
//# sourceMappingURL=VennDefaultTheme.js.map