import { __extends } from "tslib";
import { Label } from "../../../core/render/Label";
/**
 * Draws an axis label.
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/xy-chart/axes/#Labels} for more info
 * @important
 */
var AxisLabel = /** @class */ (function (_super) {
    __extends(AxisLabel, _super);
    function AxisLabel() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        Object.defineProperty(_this, "_tickPoints", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: []
        });
        return _this;
    }
    Object.defineProperty(AxisLabel, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "AxisLabel"
    });
    Object.defineProperty(AxisLabel, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Label.classNames.concat([AxisLabel.className])
    });
    return AxisLabel;
}(Label));
export { AxisLabel };
//# sourceMappingURL=AxisLabel.js.map