import { __assign, __extends } from "tslib";
import { DataItem } from "../../../core/render/Component";
import { ValueAxis } from "./ValueAxis";
import * as $type from "../../../core/util/Type";
import * as $order from "../../../core/util/Order";
import * as $array from "../../../core/util/Array";
import * as $object from "../../../core/util/Object";
import * as $utils from "../../../core/util/Utils";
import * as $time from "../../../core/util/Time";
/**
 * Creates a date axis.
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/xy-chart/axes/date-axis/} for more info
 * @important
 */
var DateAxis = /** @class */ (function (_super) {
    __extends(DateAxis, _super);
    function DateAxis() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        Object.defineProperty(_this, "_dataGrouped", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: false
        });
        Object.defineProperty(_this, "_groupingCalculated", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: false
        });
        Object.defineProperty(_this, "_intervalDuration", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 1
        });
        Object.defineProperty(_this, "_baseDuration", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 1
        });
        return _this;
    }
    Object.defineProperty(DateAxis.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this._settings.themeTags = $utils.mergeTags(this._settings.themeTags, ["axis"]);
            _super.prototype._afterNew.call(this);
            this._setBaseInterval(this.get("baseInterval"));
        }
    });
    Object.defineProperty(DateAxis.prototype, "_updateChildren", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._updateChildren.call(this);
            if (this.isDirty("baseInterval")) {
                this._setBaseInterval(this.get("baseInterval"));
            }
        }
    });
    Object.defineProperty(DateAxis.prototype, "_setBaseInterval", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (interval) {
            this.setPrivateRaw("baseInterval", interval);
            this._baseDuration = $time.getIntervalDuration(interval);
        }
    });
    Object.defineProperty(DateAxis.prototype, "_groupData", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            var min = this.getPrivate("min");
            var max = this.getPrivate("max");
            if (($type.isNumber(min) && $type.isNumber(max))) {
                this.setPrivateRaw("maxZoomFactor", Math.round((this.getPrivate("max", 0) - this.getPrivate("min", 0)) / this.baseMainDuration()));
                var groupInterval = this.getPrivate("groupInterval");
                if (groupInterval) {
                    this._setBaseInterval(groupInterval);
                }
                else {
                    this._setBaseInterval(this.get("baseInterval"));
                }
                if (this.isDirty("groupInterval")) {
                    var groupInterval_1 = this.get("groupInterval");
                    if (groupInterval_1) {
                        this.setRaw("groupIntervals", [groupInterval_1]);
                    }
                }
                if (this.isDirty("groupData")) {
                    if (!this._dataGrouped) {
                        if (this.get("groupData")) {
                            $array.each(this.series, function (series) {
                                _this._groupSeriesData(series);
                            });
                            this._handleRangeChange();
                        }
                        else {
                            var baseInterval = this.get("baseInterval");
                            var mainDataSetId_1 = baseInterval.timeUnit + baseInterval.count;
                            $array.each(this.series, function (series) {
                                series.setDataSet(mainDataSetId_1);
                            });
                            this._setBaseInterval(baseInterval);
                            this.setPrivateRaw("groupInterval", undefined);
                            this.markDirtyExtremes();
                        }
                        this._dataGrouped = true;
                    }
                }
            }
        }
    });
    Object.defineProperty(DateAxis.prototype, "_groupSeriesData", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (series) {
            var _this = this;
            if (this.get("groupData") && !series.get("groupDataDisabled")) {
                // make array of intervals which will be used;
                var intervals_1 = [];
                var baseDuration_1 = this.baseMainDuration();
                var groupIntervals = this.get("groupIntervals");
                if (groupIntervals) { }
                $array.each(groupIntervals, function (interval) {
                    var intervalDuration = $time.getIntervalDuration(interval);
                    if (intervalDuration > baseDuration_1) {
                        intervals_1.push(interval);
                    }
                });
                series._dataSets = {};
                var key_1 = this.getPrivate("name") + this.get("renderer").getPrivate("letter");
                var fields_1;
                var baseAxis = series.get("baseAxis");
                if (series.get("xAxis") === baseAxis) {
                    fields_1 = series._valueYFields;
                }
                else if (series.get("yAxis") === baseAxis) {
                    fields_1 = series._valueXFields;
                }
                var dataItems_1 = series._mainDataItems;
                var baseInterval = this.get("baseInterval");
                var mainDataSetId = baseInterval.timeUnit + baseInterval.count;
                series._dataSets[mainDataSetId] = dataItems_1;
                $array.eachContinue(intervals_1, function (interval) {
                    var previousTime = -Infinity;
                    var dataSetId = interval.timeUnit + interval.count;
                    series._dataSets[dataSetId] = [];
                    var newDataItem;
                    var sum = {};
                    var count = {};
                    var groupFieldValues = {};
                    var workingFields = {};
                    $array.each(fields_1, function (field) {
                        sum[field] = 0;
                        count[field] = 0;
                        groupFieldValues[field] = series.get((field + "Grouped"));
                        workingFields[field] = field + "Working";
                    });
                    var intervalDuration = $time.getDuration(interval.timeUnit);
                    $array.each(dataItems_1, function (dataItem) {
                        var time = dataItem.get(key_1);
                        var roundedTime = $time.round(new Date(time), interval.timeUnit, interval.count, _this._root.locale.firstDayOfWeek, _this._root.utc, undefined, _this._root.timezone).getTime();
                        var dataContext;
                        if (previousTime < roundedTime - intervalDuration / 24) {
                            dataContext = $object.copy(dataItem.dataContext);
                            newDataItem = new DataItem(series, dataContext, series._makeDataItem(dataContext));
                            newDataItem.setRaw(key_1, roundedTime);
                            series._dataSets[dataSetId].push(newDataItem);
                            $array.each(fields_1, function (field) {
                                var value = dataItem.get(field);
                                if ($type.isNumber(value)) {
                                    newDataItem.setRaw(field, value);
                                    newDataItem.setRaw(workingFields[field], value);
                                    count[field]++;
                                    sum[field] += value;
                                }
                            });
                        }
                        else {
                            $array.each(fields_1, function (field) {
                                var groupKey = groupFieldValues[field];
                                var value = dataItem.get(field);
                                if (value !== undefined) {
                                    var currentValue = newDataItem.get(field);
                                    switch (groupKey) {
                                        case "close":
                                            newDataItem.setRaw(field, value);
                                            break;
                                        case "sum":
                                            newDataItem.setRaw(field, currentValue + value);
                                            break;
                                        case "open":
                                            break;
                                        case "low":
                                            if (value < currentValue) {
                                                newDataItem.setRaw(field, value);
                                            }
                                            break;
                                        case "high":
                                            if (value > currentValue) {
                                                newDataItem.setRaw(field, value);
                                            }
                                            break;
                                        case "average":
                                            count[field]++;
                                            sum[field] += value;
                                            var average = sum[field] / count[field];
                                            newDataItem.setRaw(field, average);
                                            break;
                                        case "extreme":
                                            if (Math.abs(value) > Math.abs(currentValue)) {
                                                newDataItem.setRaw(field, value);
                                            }
                                            break;
                                    }
                                    newDataItem.setRaw(workingFields[field], newDataItem.get(field));
                                    var dataContext_1 = $object.copy(dataItem.dataContext);
                                    dataContext_1[key_1] = roundedTime;
                                    newDataItem.dataContext = dataContext_1;
                                }
                            });
                        }
                        previousTime = roundedTime;
                    });
                    if (series._dataSets[dataSetId].length < _this.get("groupCount", Infinity)) {
                        return false;
                    }
                    return true;
                });
                if (series._dataSetId) {
                    series.setDataSet(series._dataSetId);
                }
                this.markDirtySize();
            }
        }
    });
    Object.defineProperty(DateAxis.prototype, "_clearDirty", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._clearDirty.call(this);
            this._groupingCalculated = false;
            this._dataGrouped = false;
        }
    });
    Object.defineProperty(DateAxis.prototype, "_handleRangeChange", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            _super.prototype._handleRangeChange.call(this);
            var selectionMin = this.getPrivate("selectionMin");
            var selectionMax = this.getPrivate("selectionMax");
            if ($type.isNumber(selectionMin) && $type.isNumber(selectionMax)) {
                if (this.get("groupData") && !this._groupingCalculated) {
                    this._groupingCalculated = true;
                    var baseInterval = this.get("baseInterval");
                    var modifiedDifference = (selectionMax - selectionMin) + (this.get("startLocation", 0) + (1 - this.get("endLocation", 1)) * this.baseDuration());
                    var groupInterval = this.get("groupInterval");
                    if (!groupInterval) {
                        var groupIntervals = this.get("groupIntervals");
                        if (groupIntervals) {
                            groupInterval = $time.chooseInterval(0, modifiedDifference, this.get("groupCount", Infinity), groupIntervals);
                            if ($time.getIntervalDuration(groupInterval) < $time.getIntervalDuration(baseInterval)) {
                                groupInterval = __assign({}, baseInterval);
                            }
                        }
                    }
                    var current = this.getPrivate("groupInterval");
                    if (groupInterval && (!current || (current.timeUnit !== groupInterval.timeUnit || current.count !== groupInterval.count))) {
                        this.setPrivateRaw("groupInterval", groupInterval);
                        this._setBaseInterval(groupInterval);
                        if (groupInterval) {
                            var newId_1 = groupInterval.timeUnit + groupInterval.count;
                            $array.each(this.series, function (series) {
                                if (series.get("baseAxis") === _this) {
                                    series.setDataSet(newId_1);
                                }
                            });
                            this.markDirtyExtremes();
                        }
                    }
                }
                $array.each(this.series, function (series) {
                    if (series.get("baseAxis") === _this) {
                        var fieldName_1 = (_this.getPrivate("name") + _this.get("renderer").getPrivate("letter"));
                        var start = $array.getSortedIndex(series.dataItems, function (dataItem) {
                            return $order.compare(dataItem.get(fieldName_1), selectionMin);
                        });
                        if (start.index > 0) {
                            start.index -= 1;
                        }
                        var end = $array.getSortedIndex(series.dataItems, function (dataItem) {
                            return $order.compare(dataItem.get(fieldName_1), selectionMax);
                        });
                        series.setPrivate("startIndex", start.index);
                        series.setPrivate("endIndex", end.index);
                    }
                });
            }
        }
    });
    Object.defineProperty(DateAxis.prototype, "_adjustMinMax", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (min, max, gridCount, _strictMode) {
            return { min: min, max: max, step: (max - min) / gridCount };
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(DateAxis.prototype, "intervalDuration", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            return this._intervalDuration;
        }
    });
    Object.defineProperty(DateAxis.prototype, "_prepareAxisItems", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var min = this.getPrivate("min");
            var max = this.getPrivate("max");
            if ($type.isNumber(min) && $type.isNumber(max)) {
                var selectionMin = this.getPrivate("selectionMin");
                var selectionMax = this.getPrivate("selectionMax");
                var renderer = this.get("renderer");
                var baseInterval = this.getPrivate("baseInterval");
                var value = selectionMin;
                var i = 0;
                var intervals = this.get("gridIntervals");
                var gridInterval = $time.chooseInterval(0, selectionMax - selectionMin, renderer.gridCount(), intervals);
                if ($time.getIntervalDuration(gridInterval) < this.baseDuration()) {
                    gridInterval = __assign({}, baseInterval);
                }
                var intervalDuration = $time.getIntervalDuration(gridInterval);
                this._intervalDuration = intervalDuration;
                var nextGridUnit = $time.getNextUnit(gridInterval.timeUnit);
                value = $time.round(new Date(selectionMin - intervalDuration), gridInterval.timeUnit, gridInterval.count, this._root.locale.firstDayOfWeek, this._root.utc, new Date(min), this._root.timezone).getTime();
                var previousValue = value - intervalDuration;
                var format = void 0;
                var formats = this.get("dateFormats");
                while (value < selectionMax + intervalDuration) {
                    var dataItem = void 0;
                    if (this.dataItems.length < i + 1) {
                        dataItem = new DataItem(this, undefined, {});
                        this._dataItems.push(dataItem);
                        this.processDataItem(dataItem);
                    }
                    else {
                        dataItem = this.dataItems[i];
                    }
                    this._createAssets(dataItem, []);
                    if (dataItem.isHidden()) {
                        dataItem.show();
                    }
                    dataItem.setRaw("value", value);
                    dataItem.setRaw("endValue", $time.add(new Date(value), gridInterval.timeUnit, gridInterval.count, this._root.utc).getTime()); //$time.round(new Date(value + intervalDuration * 1.1), gridInterval.timeUnit, gridInterval.count).getTime());
                    var date = new Date(value);
                    format = formats[gridInterval.timeUnit];
                    if (nextGridUnit && this.get("markUnitChange") && $type.isNumber(previousValue)) {
                        if (gridInterval.timeUnit != "year") {
                            if ($time.checkChange(value, previousValue, nextGridUnit, this._root.utc, this._root.timezone)) {
                                format = this.get("periodChangeDateFormats")[gridInterval.timeUnit];
                            }
                        }
                    }
                    var label = dataItem.get("label");
                    if (label) {
                        label.set("text", this._root.dateFormatter.format(date, format));
                    }
                    this._prepareDataItem(dataItem, gridInterval.count);
                    previousValue = value;
                    value = $time.add(new Date(value), gridInterval.timeUnit, gridInterval.count, this._root.utc).getTime();
                    i++;
                }
                for (var j = i; j < this.dataItems.length; j++) {
                    this.dataItems[j].hide();
                }
                $array.each(this.series, function (series) {
                    if (series.inited) {
                        series._markDirtyAxes();
                    }
                });
            }
            this._updateGhost();
        }
    });
    Object.defineProperty(DateAxis.prototype, "_fixMin", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (min) {
            var baseInterval = this.getPrivate("baseInterval");
            var startTime = $time.round(new Date(min), baseInterval.timeUnit, baseInterval.count, this._root.locale.firstDayOfWeek, this._root.utc, undefined, this._root.timezone).getTime();
            var endTime = $time.add(new Date(startTime), baseInterval.timeUnit, baseInterval.count, this._root.utc).getTime();
            return startTime + (endTime - startTime) * this.get("startLocation", 0);
        }
    });
    /* goes up to the year
    protected _getFormat(timeUnit: TimeUnit, value: number, previousValue: number) {
        const formats = this.get("dateFormats")!;
        let format = formats[timeUnit];

        if (this.get("markUnitChange")) {
            let nextGridUnit = $time.getNextUnit(timeUnit);

            while (nextGridUnit != undefined) {

                if (nextGridUnit) {
                    if (timeUnit != "year") {
                        if ($time.checkChange(value, previousValue, nextGridUnit, this._root.utc, this._root.timezone)) {
                            format = this.get("periodChangeDateFormats")![timeUnit];
                            timeUnit = nextGridUnit;
                            nextGridUnit = $time.getNextUnit(nextGridUnit);
                        }
                        else {
                            nextGridUnit = undefined;
                        }
                    }
                    else {
                        nextGridUnit = undefined;
                    }
                }
            }
        }
        return format;
    }
    */
    Object.defineProperty(DateAxis.prototype, "_fixMax", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (max) {
            var baseInterval = this.getPrivate("baseInterval");
            var startTime = $time.round(new Date(max), baseInterval.timeUnit, baseInterval.count, this._root.locale.firstDayOfWeek, this._root.utc, undefined, this._root.timezone).getTime();
            var endTime = $time.add(new Date(startTime), baseInterval.timeUnit, baseInterval.count, this._root.utc).getTime();
            return startTime + (endTime - startTime) * this.get("endLocation", 1);
        }
    });
    Object.defineProperty(DateAxis.prototype, "_updateDates", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (_date) {
        }
    });
    /**
     * Returns a duration of currently active `baseInterval` in milliseconds.
     *
     * @return Duration
     */
    Object.defineProperty(DateAxis.prototype, "baseDuration", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            return this._baseDuration;
            //return $time.getIntervalDuration(this.getPrivate("baseInterval"));
        }
    });
    /**
     * Returns a duration of user-defined `baseInterval` in milliseconds.
     *
     * @return Duration
     */
    Object.defineProperty(DateAxis.prototype, "baseMainDuration", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            return $time.getIntervalDuration(this.get("baseInterval"));
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(DateAxis.prototype, "processSeriesDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, fields) {
            var _this = this;
            var baseInterval = this.getPrivate("baseInterval");
            dataItem.open = {};
            dataItem.close = {};
            $array.each(fields, function (field) {
                var value = dataItem.get(field);
                if ($type.isNumber(value)) {
                    var startTime = $time.round(new Date(value), baseInterval.timeUnit, baseInterval.count, _this._root.locale.firstDayOfWeek, _this._root.utc, undefined, _this._root.timezone).getTime();
                    var endTime = $time.add(new Date(startTime), baseInterval.timeUnit, baseInterval.count, _this._root.utc).getTime();
                    dataItem.open[field] = startTime;
                    dataItem.close[field] = endTime;
                    _this._updateDates(startTime);
                }
            });
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(DateAxis.prototype, "getDataItemPositionX", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, field, cellLocation, axisLocation) {
            var openValue;
            var closeValue;
            if (dataItem.open && dataItem.close) {
                openValue = dataItem.open[field];
                closeValue = dataItem.close[field];
            }
            else {
                openValue = dataItem.get(field);
                closeValue = openValue;
            }
            var value = openValue + (closeValue - openValue) * cellLocation;
            value = this._baseValue + (value - this._baseValue) * axisLocation;
            return this.valueToPosition(value);
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(DateAxis.prototype, "getDataItemCoordinateX", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, field, cellLocation, axisLocation) {
            return this._settings.renderer.positionToCoordinate(this.getDataItemPositionX(dataItem, field, cellLocation, axisLocation));
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(DateAxis.prototype, "getDataItemPositionY", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, field, cellLocation, axisLocation) {
            var openValue;
            var closeValue;
            if (dataItem.open && dataItem.close) {
                openValue = dataItem.open[field];
                closeValue = dataItem.close[field];
            }
            else {
                openValue = dataItem.get(field);
                closeValue = openValue;
            }
            var value = openValue + (closeValue - openValue) * cellLocation;
            value = this._baseValue + (value - this._baseValue) * axisLocation;
            return this.valueToPosition(value);
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(DateAxis.prototype, "getDataItemCoordinateY", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, field, cellLocation, axisLocation) {
            return this._settings.renderer.positionToCoordinate(this.getDataItemPositionY(dataItem, field, cellLocation, axisLocation));
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(DateAxis.prototype, "roundAxisPosition", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (position, location) {
            var value = this.positionToValue(position);
            var baseInterval = this.getPrivate("baseInterval");
            value = $time.round(new Date(value), baseInterval.timeUnit, baseInterval.count, this._root.locale.firstDayOfWeek, this._root.utc, undefined, this._root.timezone).getTime();
            var endValue = value;
            if (location > 0) {
                endValue = $time.add(new Date(value), baseInterval.timeUnit, baseInterval.count, this._root.utc).getTime();
            }
            return this.valueToPosition(value + (endValue - value) * location);
        }
    });
    /**
     * Returns text to be used in an axis tooltip for specific relative position.
     *
     * @param   position  Position
     * @return            Tooltip text
     */
    Object.defineProperty(DateAxis.prototype, "getTooltipText", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (position) {
            //@todo number formatter + tag
            var format = this.get("tooltipDateFormats")[this.getPrivate("baseInterval").timeUnit];
            return this._root.dateFormatter.format(new Date(this.positionToValue(position) + this.get("tooltipIntervalOffset", -this.get("tooltipLocation", 0.5)) * this.baseDuration()), this.get("tooltipDateFormat", format));
        }
    });
    /**
     * Returns a data item from series that is closest to the `position`.
     *
     * @param   series    Series
     * @param   position  Relative position
     * @return            Data item
     */
    Object.defineProperty(DateAxis.prototype, "getSeriesItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (series, position) {
            var fieldName = (this.getPrivate("name") + this.get("renderer").getPrivate("letter"));
            var value = this.positionToValue(position);
            var result = $array.getSortedIndex(series.dataItems, function (dataItem) {
                var diValue = 0;
                if (dataItem.open) {
                    diValue = dataItem.open[fieldName];
                }
                return $order.compare(diValue, value);
            });
            if (series.get("snapTooltip")) {
                var first = series.dataItems[result.index - 1];
                var second = series.dataItems[result.index];
                if (first && second) {
                    if (first.open && second.close) {
                        var open_1 = first.open[fieldName];
                        var close_1 = second.close[fieldName];
                        if (Math.abs(value - open_1) > Math.abs(value - close_1)) {
                            return second;
                        }
                    }
                }
                return first;
            }
            else {
                // @todo check if is in range
                var dataItem = series.dataItems[result.index - 1];
                if (dataItem) {
                    if (dataItem.open && dataItem.close) {
                        var open_2 = dataItem.open[fieldName];
                        var close_2 = dataItem.close[fieldName];
                        if (value >= open_2 && value <= close_2) {
                            return dataItem;
                        }
                    }
                }
            }
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(DateAxis.prototype, "shouldGap", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, nextItem, autoGapCount, fieldName) {
            var value1 = dataItem.get(fieldName);
            var value2 = nextItem.get(fieldName);
            if (value2 - value1 > this.baseDuration() * autoGapCount) {
                return true;
            }
            return false;
        }
    });
    /**
     * Zooms the axis to specific `start` and `end` dates.
     *
     * Optional `duration` specifies duration of zoom animation in milliseconds.
     *
     * @param  start     Start Date
     * @param  end       End Date
     * @param  duration  Duration in milliseconds
     */
    Object.defineProperty(DateAxis.prototype, "zoomToDates", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (start, end, duration) {
            this.zoomToValues(start.getTime(), end.getTime(), duration);
        }
    });
    /**
     * Returns a `Date` object corresponding to specific position within plot
     * area.
     *
     * @param   position  Pposition
     * @return            Date
     */
    Object.defineProperty(DateAxis.prototype, "positionToDate", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (position) {
            return new Date(this.positionToValue(position));
        }
    });
    /**
     * Returns a relative position within plot area that corresponds to specific
     * date.
     *
     * @param   date  Date
     * @return        Position
     */
    Object.defineProperty(DateAxis.prototype, "dateToPosition", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (date) {
            return this.valueToPosition(date.getTime());
        }
    });
    Object.defineProperty(DateAxis, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "DateAxis"
    });
    Object.defineProperty(DateAxis, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: ValueAxis.classNames.concat([DateAxis.className])
    });
    return DateAxis;
}(ValueAxis));
export { DateAxis };
//# sourceMappingURL=DateAxis.js.map