import { __extends, __values } from "tslib";
import { ValueAxis } from "./ValueAxis";
import * as $utils from "../../../core/util/Utils";
import * as $math from "../../../core/util/Math";
/**
 * Creates a duration axis.
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/xy-chart/axes/duration-axis/} for more info
 * @important
 */
var DurationAxis = /** @class */ (function (_super) {
    __extends(DurationAxis, _super);
    function DurationAxis() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        Object.defineProperty(_this, "_dataGrouped", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: false
        });
        Object.defineProperty(_this, "_groupingCalculated", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: false
        });
        Object.defineProperty(_this, "_intervalDuration", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 1
        });
        return _this;
    }
    Object.defineProperty(DurationAxis.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this._settings.themeTags = $utils.mergeTags(this._settings.themeTags, ["axis"]);
            _super.prototype._afterNew.call(this);
        }
    });
    Object.defineProperty(DurationAxis.prototype, "_adjustMinMax", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (min, max, gridCount, strictMode) {
            var e_1, _a;
            var minMaxStep;
            var durationFormatter = this.getDurationFormatter();
            var baseUnit = this.get("baseUnit");
            // we don't allow to go to smaller units, setting so to avoid invalidation
            this.setRaw("maxPrecision", 0);
            if (baseUnit == "millisecond" || baseUnit == "second" || baseUnit == "minute" || baseUnit == "hour") {
                // will fail if 0
                if (gridCount <= 1) {
                    gridCount = 1;
                }
                gridCount = Math.round(gridCount);
                //let initialMin: number = min;
                //let initialMax: number = max;
                var difference = max - min;
                // in case min and max is the same, use max
                if (difference === 0) {
                    difference = Math.abs(max);
                }
                var step = difference / gridCount;
                var divisors = [60, 30, 20, 15, 10, 2, 1];
                var realDivisor = 1;
                if (baseUnit == "hour") {
                    divisors = [24, 12, 6, 4, 2, 1];
                }
                try {
                    for (var divisors_1 = __values(divisors), divisors_1_1 = divisors_1.next(); !divisors_1_1.done; divisors_1_1 = divisors_1.next()) {
                        var divisor = divisors_1_1.value;
                        if (difference / divisor > gridCount) {
                            realDivisor = divisor;
                            break;
                        }
                    }
                }
                catch (e_1_1) { e_1 = { error: e_1_1 }; }
                finally {
                    try {
                        if (divisors_1_1 && !divisors_1_1.done && (_a = divisors_1.return)) _a.call(divisors_1);
                    }
                    finally { if (e_1) throw e_1.error; }
                }
                var count = Math.ceil(((max - min) / realDivisor) / gridCount);
                var exponent = Math.log(Math.abs(count)) * Math.LOG10E;
                var power = Math.pow(10, Math.floor(exponent)) / 10;
                var reducedCount = count / power;
                // find closest to divisor
                var closest = $math.closest(divisors, reducedCount);
                count = closest * power;
                step = realDivisor * count;
                min = Math.floor(min / step) * step;
                max = Math.ceil(max / step) * step;
                /*
                causese SO with seconds
                if (strictMode) {
                    min -= step;
                    if (min < 0 && initialMin >= 0) {
                        min = 0;
                    }
                    max += step;
    
                    if (max > 0 && initialMax <= 0) {
                        max = 0;
                    }
                }*/
                minMaxStep = { min: min, max: max, step: step };
            }
            else {
                minMaxStep = _super.prototype._adjustMinMax.call(this, min, max, gridCount, strictMode);
            }
            // choose duration formatter based on step
            this.setPrivate("durationFormat", durationFormatter.getFormat(minMaxStep.step, minMaxStep.max, baseUnit));
            return minMaxStep;
        }
    });
    Object.defineProperty(DurationAxis.prototype, "_formatText", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (value) {
            var formatter = this.getDurationFormatter();
            return formatter.format(value, this.getPrivate("durationFormat"), this.get("baseUnit"));
        }
    });
    /**
     * Returns text to be used in an axis tooltip for specific relative position.
     *
     * @param   position  Position
     * @return            Tooltip text
     */
    Object.defineProperty(DurationAxis.prototype, "getTooltipText", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (position) {
            var formatter = this.getDurationFormatter();
            var extraDecimals = this.get("extraTooltipPrecision", 0);
            var decimals = this.getPrivate("stepDecimalPlaces", 0) + extraDecimals;
            var value = $math.round(this.positionToValue(position), decimals);
            return formatter.format(value, this.getPrivate("durationFormat"), this.get("baseUnit"));
        }
    });
    Object.defineProperty(DurationAxis, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "DurationAxis"
    });
    Object.defineProperty(DurationAxis, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: ValueAxis.classNames.concat([DurationAxis.className])
    });
    return DurationAxis;
}(ValueAxis));
export { DurationAxis };
//# sourceMappingURL=DurationAxis.js.map