import { __extends } from "tslib";
import { RoundedRectangle } from "../../../core/render/RoundedRectangle";
/**
 * A candle element used in a [[CandlestickSeries]].
 */
var Candlestick = /** @class */ (function (_super) {
    __extends(Candlestick, _super);
    function Candlestick() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(Candlestick.prototype, "_beforeChanged", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._beforeChanged.call(this);
            if (this.isDirty("lowX0") || this.isDirty("lowY0") || this.isDirty("lowX1") || this.isDirty("lowY1") || this.isDirty("highX0") || this.isDirty("highX1") || this.isDirty("highY0") || this.isDirty("highY1")) {
                this._clear = true;
            }
        }
    });
    Object.defineProperty(Candlestick.prototype, "_draw", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._draw.call(this);
            var display = this._display;
            display.moveTo(this.get("lowX0", 0), this.get("lowY0", 0));
            display.lineTo(this.get("lowX1", 0), this.get("lowY1", 0));
            display.moveTo(this.get("highX0", 0), this.get("highY0", 0));
            display.lineTo(this.get("highX1", 0), this.get("highY1", 0));
        }
    });
    Object.defineProperty(Candlestick, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "Candlestick"
    });
    Object.defineProperty(Candlestick, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: RoundedRectangle.classNames.concat([Candlestick.className])
    });
    return Candlestick;
}(RoundedRectangle));
export { Candlestick };
//# sourceMappingURL=Candlestick.js.map