import { __extends } from "tslib";
import { ColumnSeries } from "./ColumnSeries";
import { Candlestick } from "./Candlestick";
import { Template } from "../../../core/util/Template";
import { ListTemplate } from "../../../core/util/List";
import * as $utils from "../../../core/util/Utils";
import * as $array from "../../../core/util/Array";
/**
 * Candlestick series.
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/xy-chart/series/candlestick-series/} for more info
 * @important
 */
var CandlestickSeries = /** @class */ (function (_super) {
    __extends(CandlestickSeries, _super);
    function CandlestickSeries() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * A list of candles in the series.
         *
         * `columns.template` can be used to configure candles.
         *
         * @default new ListTemplate<Candlestick>
         */
        Object.defineProperty(_this, "columns", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: new ListTemplate(Template.new({
                themeTags: ["autocolor"]
            }), function () { return Candlestick._new(_this._root, {
                themeTags: $utils.mergeTags(_this.columns.template.get("themeTags", []), ["candlestick", "series", "column"])
            }, [_this.columns.template]); })
        });
        return _this;
    }
    /**
     * @ignore
     */
    Object.defineProperty(CandlestickSeries.prototype, "makeColumn", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, listTemplate) {
            var column = this.mainContainer.children.push(listTemplate.make());
            column._setDataItem(dataItem);
            listTemplate.push(column);
            return column;
        }
    });
    Object.defineProperty(CandlestickSeries.prototype, "_updateGraphics", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, previousDataItem) {
            _super.prototype._updateGraphics.call(this, dataItem, previousDataItem);
            var xAxis = this.getRaw("xAxis");
            var yAxis = this.getRaw("yAxis");
            var baseAxis = this.getRaw("baseAxis");
            var vcy = this.get("vcy", 1);
            var vcx = this.get("vcx", 1);
            var lx0;
            var lx1;
            var ly0;
            var ly1;
            var hx0;
            var hx1;
            var hy0;
            var hy1;
            var locationX = this.get("locationX", dataItem.get("locationX", 0.5));
            var locationY = this.get("locationY", dataItem.get("locationY", 0.5));
            var openLocationX = this.get("openLocationX", dataItem.get("openLocationX", locationX));
            var openLocationY = this.get("openLocationY", dataItem.get("openLocationY", locationY));
            var orientation;
            if (yAxis === baseAxis) {
                var open_1 = xAxis.getDataItemPositionX(dataItem, this._xOpenField, 1, vcx);
                var close_1 = xAxis.getDataItemPositionX(dataItem, this._xField, 1, vcx);
                lx1 = xAxis.getDataItemPositionX(dataItem, this._xLowField, 1, vcx);
                hx1 = xAxis.getDataItemPositionX(dataItem, this._xHighField, 1, vcx);
                hx0 = Math.max(open_1, close_1);
                lx0 = Math.min(open_1, close_1);
                var startLocation = this._aLocationY0 + openLocationY - 0.5;
                var endLocation = this._aLocationY1 + locationY - 0.5;
                ly0 = yAxis.getDataItemPositionY(dataItem, this._yField, startLocation + (endLocation - startLocation) / 2, vcy);
                ly1 = ly0;
                hy0 = ly0;
                hy1 = ly0;
                orientation = "horizontal";
            }
            else {
                var open_2 = yAxis.getDataItemPositionY(dataItem, this._yOpenField, 1, vcy);
                var close_2 = yAxis.getDataItemPositionY(dataItem, this._yField, 1, vcy);
                ly1 = yAxis.getDataItemPositionY(dataItem, this._yLowField, 1, vcy);
                hy1 = yAxis.getDataItemPositionY(dataItem, this._yHighField, 1, vcy);
                hy0 = Math.max(open_2, close_2);
                ly0 = Math.min(open_2, close_2);
                var startLocation = this._aLocationX0 + openLocationX - 0.5;
                var endLocation = this._aLocationX1 + locationX - 0.5;
                lx0 = xAxis.getDataItemPositionX(dataItem, this._xField, startLocation + (endLocation - startLocation) / 2, vcx);
                lx1 = lx0;
                hx0 = lx0;
                hx1 = lx0;
                orientation = "vertical";
            }
            this._updateCandleGraphics(dataItem, lx0, lx1, ly0, ly1, hx0, hx1, hy0, hy1, orientation);
        }
    });
    Object.defineProperty(CandlestickSeries.prototype, "_updateCandleGraphics", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, lx0, lx1, ly0, ly1, hx0, hx1, hy0, hy1, orientation) {
            var column = dataItem.get("graphics");
            if (column) {
                var pl0_1 = this.getPoint(lx0, ly0);
                var pl1_1 = this.getPoint(lx1, ly1);
                var ph0_1 = this.getPoint(hx0, hy0);
                var ph1_1 = this.getPoint(hx1, hy1);
                var x_1 = column.x();
                var y_1 = column.y();
                column.set("lowX0", pl0_1.x - x_1);
                column.set("lowY0", pl0_1.y - y_1);
                column.set("lowX1", pl1_1.x - x_1);
                column.set("lowY1", pl1_1.y - y_1);
                column.set("highX0", ph0_1.x - x_1);
                column.set("highY0", ph0_1.y - y_1);
                column.set("highX1", ph1_1.x - x_1);
                column.set("highY1", ph1_1.y - y_1);
                column.set("orientation", orientation);
                var rangeGraphics = dataItem.get("rangeGraphics");
                if (rangeGraphics) {
                    $array.each(rangeGraphics, function (column) {
                        column.set("lowX0", pl0_1.x - x_1);
                        column.set("lowY0", pl0_1.y - y_1);
                        column.set("lowX1", pl1_1.x - x_1);
                        column.set("lowY1", pl1_1.y - y_1);
                        column.set("highX0", ph0_1.x - x_1);
                        column.set("highY0", ph0_1.y - y_1);
                        column.set("highX1", ph1_1.x - x_1);
                        column.set("highY1", ph1_1.y - y_1);
                        column.set("orientation", orientation);
                    });
                }
            }
        }
    });
    Object.defineProperty(CandlestickSeries.prototype, "_processAxisRange", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (axisRange) {
            var _this = this;
            _super.prototype._processAxisRange.call(this, axisRange);
            axisRange.columns = new ListTemplate(Template.new({}), function () { return Candlestick._new(_this._root, {
                themeTags: $utils.mergeTags(axisRange.columns.template.get("themeTags", []), ["candlestick", "series", "column"]),
            }, [_this.columns.template, axisRange.columns.template]); });
        }
    });
    Object.defineProperty(CandlestickSeries, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "CandlestickSeries"
    });
    Object.defineProperty(CandlestickSeries, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: ColumnSeries.classNames.concat([CandlestickSeries.className])
    });
    return CandlestickSeries;
}(ColumnSeries));
export { CandlestickSeries };
//# sourceMappingURL=CandlestickSeries.js.map