import { __extends } from "tslib";
import { Candlestick } from "./Candlestick";
var OHLC = /** @class */ (function (_super) {
    __extends(OHLC, _super);
    function OHLC() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(OHLC.prototype, "_draw", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var display = this._display;
            display.moveTo(this.get("lowX1", 0), this.get("lowY1", 0));
            display.lineTo(this.get("highX1", 0), this.get("highY1", 0));
            var w = this.width();
            var h = this.height();
            if (this.get("orientation") == "vertical") {
                var lY = h;
                var hY = 0;
                display.moveTo(0, lY);
                display.lineTo(w / 2, lY);
                display.moveTo(w / 2, hY);
                display.lineTo(w, hY);
            }
            else {
                var lX = 0;
                var hX = w;
                display.moveTo(lX, 0);
                display.lineTo(lX, h / 2);
                display.moveTo(hX, h / 2);
                display.lineTo(hX, h);
            }
        }
    });
    Object.defineProperty(OHLC, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "OHLC"
    });
    Object.defineProperty(OHLC, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Candlestick.classNames.concat([OHLC.className])
    });
    return OHLC;
}(Candlestick));
export { OHLC };
//# sourceMappingURL=OHLC.js.map