import { __extends } from "tslib";
import { CandlestickSeries } from "./CandlestickSeries";
import { OHLC } from "./OHLC";
import { Template } from "../../../core/util/Template";
import { ListTemplate } from "../../../core/util/List";
import * as $utils from "../../../core/util/Utils";
/**
 * OHLC series.
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/xy-chart/series/candlestick-series/} for more info
 * @important
 */
var OHLCSeries = /** @class */ (function (_super) {
    __extends(OHLCSeries, _super);
    function OHLCSeries() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * A list of OHLC bars in the series.
         *
         * `columns.template` can be used to configure OHLC bars.
         *
         * @default new ListTemplate<OHLC>
         */
        Object.defineProperty(_this, "columns", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: new ListTemplate(Template.new({
                themeTags: ["autocolor"]
            }), function () { return OHLC._new(_this._root, {
                themeTags: $utils.mergeTags(_this.columns.template.get("themeTags", []), ["ohlc", "series", "column"])
            }, [_this.columns.template]); })
        });
        return _this;
    }
    /**
     * @ignore
     */
    Object.defineProperty(OHLCSeries.prototype, "makeColumn", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, listTemplate) {
            var column = this.mainContainer.children.push(listTemplate.make());
            column._setDataItem(dataItem);
            listTemplate.push(column);
            return column;
        }
    });
    Object.defineProperty(OHLCSeries.prototype, "_processAxisRange", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (axisRange) {
            var _this = this;
            _super.prototype._processAxisRange.call(this, axisRange);
            axisRange.columns = new ListTemplate(Template.new({}), function () { return OHLC._new(_this._root, {
                themeTags: $utils.mergeTags(axisRange.columns.template.get("themeTags", []), ["ohlc", "series", "column"]),
            }, [_this.columns.template, axisRange.columns.template]); });
        }
    });
    Object.defineProperty(OHLCSeries, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "OHLCSeries"
    });
    Object.defineProperty(OHLCSeries, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: CandlestickSeries.classNames.concat([OHLCSeries.className])
    });
    return OHLCSeries;
}(CandlestickSeries));
export { OHLCSeries };
//# sourceMappingURL=OHLCSeries.js.map