import { __extends } from "tslib";
import { LineSeries } from "./LineSeries";
import { curveMonotoneXTension } from "../../../core/render/MonotoneXTension";
/**
 * Smoothed line series suitable for horizontal plots.
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/xy-chart/series/smoothed-series/} for more info
 */
var SmoothedXLineSeries = /** @class */ (function (_super) {
    __extends(SmoothedXLineSeries, _super);
    function SmoothedXLineSeries() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(SmoothedXLineSeries.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this._setDefault("curveFactory", curveMonotoneXTension(this.get("tension", 0.5)));
            _super.prototype._afterNew.call(this);
        }
    });
    Object.defineProperty(SmoothedXLineSeries.prototype, "_updateChildren", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            if (this.isDirty("tension")) {
                this.set("curveFactory", curveMonotoneXTension(this.get("tension", 0.5)));
                this._valuesDirty = true;
            }
            _super.prototype._updateChildren.call(this);
        }
    });
    Object.defineProperty(SmoothedXLineSeries, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "SmoothedXLineSeries"
    });
    Object.defineProperty(SmoothedXLineSeries, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: LineSeries.classNames.concat([SmoothedXLineSeries.className])
    });
    return SmoothedXLineSeries;
}(LineSeries));
export { SmoothedXLineSeries };
//# sourceMappingURL=SmoothedXLineSeries.js.map