import { __extends } from "tslib";
import { LineSeries } from "./LineSeries";
import { curveCardinal } from "d3-shape";
/**
 * Smoothed line series suitable for XY (scatter) charts
 *
 * @see {@link https://www.amcharts.com/docs/v5/charts/xy-chart/series/smoothed-series/} for more info
 */
var SmoothedXYLineSeries = /** @class */ (function (_super) {
    __extends(SmoothedXYLineSeries, _super);
    function SmoothedXYLineSeries() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(SmoothedXYLineSeries.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this._setDefault("curveFactory", curveCardinal.tension(this.get("tension", 0.5)));
            _super.prototype._afterNew.call(this);
        }
    });
    Object.defineProperty(SmoothedXYLineSeries.prototype, "_updateChildren", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            if (this.isDirty("tension")) {
                this.set("curveFactory", curveCardinal.tension(this.get("tension", 0.5)));
                this._valuesDirty = true;
            }
            _super.prototype._updateChildren.call(this);
        }
    });
    Object.defineProperty(SmoothedXYLineSeries, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "SmoothedXYLineSeries"
    });
    Object.defineProperty(SmoothedXYLineSeries, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: LineSeries.classNames.concat([SmoothedXYLineSeries.className])
    });
    return SmoothedXYLineSeries;
}(LineSeries));
export { SmoothedXYLineSeries };
//# sourceMappingURL=SmoothedXYLineSeries.js.map