import { __extends } from "tslib";
import { LineSeries } from "./LineSeries";
import { p100 } from "../../../core/util/Percent";
import { curveStepAfter } from "d3-shape";
var StepLineSeries = /** @class */ (function (_super) {
    __extends(StepLineSeries, _super);
    function StepLineSeries() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(StepLineSeries.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this._setDefault("curveFactory", curveStepAfter);
            _super.prototype._afterNew.call(this);
        }
    });
    Object.defineProperty(StepLineSeries.prototype, "_getPoints", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, o) {
            var points = o.points;
            var width = this.get("stepWidth", p100).value / 2;
            var itemLocationX0 = dataItem.get("locationX", o.locationX);
            var itemLocationY0 = dataItem.get("locationY", o.locationY);
            var itemLocationX1 = itemLocationX0;
            var itemLocationY1 = itemLocationY0;
            if (o.baseAxis === o.xAxis) {
                itemLocationX0 -= width;
                itemLocationX1 += width;
            }
            else if (o.baseAxis === o.yAxis) {
                itemLocationY0 -= width;
                itemLocationY1 += width;
            }
            var xPos0 = o.xAxis.getDataItemPositionX(dataItem, o.xField, itemLocationX0, o.vcx);
            var yPos0 = o.yAxis.getDataItemPositionY(dataItem, o.yField, itemLocationY0, o.vcy);
            var xPos1 = o.xAxis.getDataItemPositionX(dataItem, o.xField, itemLocationX1, o.vcx);
            var yPos1 = o.yAxis.getDataItemPositionY(dataItem, o.yField, itemLocationY1, o.vcy);
            if (this._shouldInclude(xPos0)) {
                var iPoint0 = this.getPoint(xPos0, yPos0);
                var point0 = [iPoint0.x, iPoint0.y];
                var iPoint1 = this.getPoint(xPos1, yPos1);
                var point1 = [iPoint1.x, iPoint1.y];
                if (o.fillVisible) {
                    var xOpenPos0 = xPos0;
                    var yOpenPos0 = yPos0;
                    var xOpenPos1 = xPos1;
                    var yOpenPos1 = yPos1;
                    if (o.baseAxis === o.xAxis) {
                        yOpenPos0 = o.basePosY;
                        yOpenPos1 = o.basePosY;
                    }
                    else if (o.baseAxis === o.yAxis) {
                        xOpenPos0 = o.basePosX;
                        xOpenPos1 = o.basePosX;
                    }
                    if (o.getOpen) {
                        var valueX = dataItem.get(o.xOpenField);
                        var valueY = dataItem.get(o.yOpenField);
                        if (valueX != null && valueY != null) {
                            itemLocationX0 = dataItem.get("openLocationX", o.openLocationX);
                            itemLocationY0 = dataItem.get("openLocationY", o.openLocationY);
                            itemLocationX1 = itemLocationX0;
                            itemLocationY1 = itemLocationY0;
                            if (o.baseAxis === o.xAxis) {
                                itemLocationX0 -= width;
                                itemLocationX1 += width;
                            }
                            else if (o.baseAxis === o.yAxis) {
                                itemLocationY0 -= width;
                                itemLocationY1 += width;
                            }
                            if (o.stacked) {
                                var stackToItemX = dataItem.get("stackToItemX");
                                var stackToItemY = dataItem.get("stackToItemY");
                                if (stackToItemX) {
                                    xOpenPos0 = o.xAxis.getDataItemPositionX(stackToItemX, o.xField, itemLocationX0, stackToItemX.component.get("vcx"));
                                    xOpenPos1 = o.xAxis.getDataItemPositionX(stackToItemX, o.xField, itemLocationX1, stackToItemX.component.get("vcx"));
                                }
                                else {
                                    if (o.yAxis === o.baseAxis) {
                                        xOpenPos0 = o.basePosX;
                                        xOpenPos1 = o.basePosX;
                                    }
                                    else if (o.baseAxis === o.yAxis) {
                                        xOpenPos0 = o.xAxis.getDataItemPositionX(dataItem, o.xOpenField, itemLocationX0, o.vcx);
                                        xOpenPos1 = o.xAxis.getDataItemPositionX(dataItem, o.xOpenField, itemLocationX1, o.vcx);
                                    }
                                }
                                if (stackToItemY) {
                                    yOpenPos0 = o.yAxis.getDataItemPositionY(stackToItemY, o.yField, itemLocationY0, stackToItemY.component.get("vcy"));
                                    yOpenPos1 = o.yAxis.getDataItemPositionY(stackToItemY, o.yField, itemLocationY1, stackToItemY.component.get("vcy"));
                                }
                                else {
                                    if (o.xAxis === o.baseAxis) {
                                        yOpenPos0 = o.basePosY;
                                        yOpenPos1 = o.basePosY;
                                    }
                                    else if (o.baseAxis === o.yAxis) {
                                        yOpenPos0 = o.yAxis.getDataItemPositionY(dataItem, o.yOpenField, itemLocationY0, o.vcy);
                                        yOpenPos1 = o.yAxis.getDataItemPositionY(dataItem, o.yOpenField, itemLocationY1, o.vcy);
                                    }
                                }
                            }
                            else {
                                xOpenPos0 = o.xAxis.getDataItemPositionX(dataItem, o.xOpenField, itemLocationX0, o.vcx);
                                yOpenPos0 = o.yAxis.getDataItemPositionY(dataItem, o.yOpenField, itemLocationY0, o.vcy);
                                xOpenPos1 = o.xAxis.getDataItemPositionX(dataItem, o.xOpenField, itemLocationX1, o.vcx);
                                yOpenPos1 = o.yAxis.getDataItemPositionY(dataItem, o.yOpenField, itemLocationY1, o.vcy);
                            }
                        }
                    }
                    var closeIPoint0 = this.getPoint(xOpenPos0, yOpenPos0);
                    var closeIPoint1 = this.getPoint(xOpenPos1, yOpenPos1);
                    point0[2] = closeIPoint0.x;
                    point0[3] = closeIPoint0.y;
                    point1[2] = closeIPoint1.x;
                    point1[3] = closeIPoint1.y;
                }
                points.push(point0);
                points.push(point1);
                dataItem.set("point", { x: point0[0] + (point1[0] - point0[0]) / 2, y: point0[1] + (point1[1] - point0[1]) / 2 });
            }
            if (this.get("noRisers")) {
                o.points = [];
                o.segments.push(points);
            }
        }
    });
    Object.defineProperty(StepLineSeries, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "StepLineSeries"
    });
    Object.defineProperty(StepLineSeries, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: LineSeries.classNames.concat([StepLineSeries.className])
    });
    return StepLineSeries;
}(LineSeries));
export { StepLineSeries };
//# sourceMappingURL=StepLineSeries.js.map