import { __extends } from "tslib";
import { Entity } from "../../core/util/Entity";
/**
 * A universal placeholder for bullet elements.
 *
 * @see {@link https://www.amcharts.com/docs/v5/concepts/common-elements/bullets/} for more info
 */
var Bullet = /** @class */ (function (_super) {
    __extends(Bullet, _super);
    function Bullet() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        // used by MapPolygons where one data item can have multiple bullets of the same kind
        Object.defineProperty(_this, "_index", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        /**
         * Target series object if it's a bullet for series.
         */
        Object.defineProperty(_this, "series", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        return _this;
    }
    Object.defineProperty(Bullet.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            // Applying themes because bullet will not have parent
            _super.prototype._afterNewApplyThemes.call(this);
        }
    });
    Object.defineProperty(Bullet.prototype, "_beforeChanged", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._beforeChanged.call(this);
            if (this.isDirty("sprite")) {
                var sprite = this.get("sprite");
                if (sprite) {
                    sprite.setAll({ position: "absolute", role: "figure" });
                    this._disposers.push(sprite);
                }
            }
            if (this.isDirty("locationX") || this.isDirty("locationY")) {
                if (this.series) {
                    this.series._positionBullet(this);
                }
            }
        }
    });
    Object.defineProperty(Bullet, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "Bullet"
    });
    Object.defineProperty(Bullet, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Entity.classNames.concat([Bullet.className])
    });
    return Bullet;
}(Entity));
export { Bullet };
//# sourceMappingURL=Bullet.js.map