import { __extends } from "tslib";
import { RoundedRectangle } from "../render/RoundedRectangle";
import { Container } from "./Container";
import * as $utils from "../../core/util/Utils";
/**
 * Draws an interactive button.
 *
 * @see {@link https://www.amcharts.com/docs/v5/concepts/common-elements/buttons/} for more info
 * @important
 */
var Button = /** @class */ (function (_super) {
    __extends(Button, _super);
    function Button() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(Button.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this._settings.themeTags = $utils.mergeTags(this._settings.themeTags, ["button"]);
            _super.prototype._afterNew.call(this);
            if (!this._settings.background) {
                this.set("background", RoundedRectangle.new(this._root, {
                    themeTags: $utils.mergeTags(this._settings.themeTags, ["background"])
                }));
            }
        }
    });
    Object.defineProperty(Button.prototype, "_prepareChildren", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._prepareChildren.call(this);
            if (this.isDirty("icon")) {
                var previous = this._prevSettings.icon;
                var icon = this.get("icon");
                if (icon !== previous) {
                    this._disposeProperty("icon");
                    if (previous) {
                        previous.dispose();
                    }
                    if (icon) {
                        this.children.push(icon);
                    }
                    this._prevSettings.icon = icon;
                }
            }
            if (this.isDirty("label")) {
                var previous = this._prevSettings.label;
                var label = this.get("label");
                if (label !== previous) {
                    this._disposeProperty("label");
                    if (previous) {
                        previous.dispose();
                    }
                    if (label) {
                        this.children.push(label);
                    }
                    this._prevSettings.label = label;
                }
            }
        }
    });
    Object.defineProperty(Button, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "Button"
    });
    Object.defineProperty(Button, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Container.classNames.concat([Button.className])
    });
    return Button;
}(Container));
export { Button };
//# sourceMappingURL=Button.js.map