import { __extends } from "tslib";
import { Container } from "../../core/render/Container";
import { p100 } from "../../core/util/Percent";
/**
 * A base class for all charts.
 */
var Chart = /** @class */ (function (_super) {
    __extends(Chart, _super);
    function Chart() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * A [[Container]] chart places its elements in.
         *
         * @default Container.new()
         */
        Object.defineProperty(_this, "chartContainer", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: _this.children.push(Container.new(_this._root, { width: p100, height: p100, interactiveChildren: false }))
        });
        /**
         * A [[Container]] chart places its bullets in.
         *
         * @default Container.new()
         */
        Object.defineProperty(_this, "bulletsContainer", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: Container.new(_this._root, { interactiveChildren: false, isMeasured: false, position: "absolute", width: p100, height: p100 })
        });
        return _this;
    }
    Object.defineProperty(Chart, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "Chart"
    });
    Object.defineProperty(Chart, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Container.classNames.concat([Chart.className])
    });
    return Chart;
}(Container));
export { Chart };
//# sourceMappingURL=Chart.js.map