import { __extends } from "tslib";
import { Graphics } from "./Graphics";
/**
 * Draws a circle.
 *
 * @see {@link https://www.amcharts.com/docs/v5/concepts/common-elements/graphics/} for more info
 * @important
 */
var Circle = /** @class */ (function (_super) {
    __extends(Circle, _super);
    function Circle() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(Circle.prototype, "_beforeChanged", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._beforeChanged.call(this);
            if (this.isDirty("radius")) {
                this._clear = true;
            }
        }
    });
    Object.defineProperty(Circle.prototype, "_changed", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._changed.call(this);
            if (this._clear) {
                this._display.drawCircle(0, 0, this.get("radius", 10));
            }
        }
    });
    Object.defineProperty(Circle, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "Circle"
    });
    Object.defineProperty(Circle, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Graphics.classNames.concat([Circle.className])
    });
    return Circle;
}(Graphics));
export { Circle };
//# sourceMappingURL=Circle.js.map