import { __extends } from "tslib";
import { Layout, eachChildren } from "./Layout";
import * as $type from "../util/Type";
import { Percent } from "../util/Percent";
/**
 * A horizontal children layout for [[Container]].
 *
 * @see {@link https://www.amcharts.com/docs/v5/concepts/common-elements/containers/#Layout} for more info
 */
var HorizontalLayout = /** @class */ (function (_super) {
    __extends(HorizontalLayout, _super);
    function HorizontalLayout() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * @ignore
     */
    Object.defineProperty(HorizontalLayout.prototype, "updateContainer", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (container) {
            var paddingLeft = container.get("paddingLeft", 0);
            var availableWidth = container.innerWidth();
            var totalPercent = 0;
            eachChildren(container, function (child) {
                if (child.get("position") == "relative") {
                    var childWidth = child.get("width");
                    if (childWidth instanceof Percent) {
                        totalPercent += childWidth.value;
                        var w = availableWidth * childWidth.value;
                        var minWidth = child.get("minWidth", -Infinity);
                        if (minWidth > w) {
                            availableWidth -= minWidth;
                            totalPercent -= childWidth.value;
                        }
                        var maxWidth = child.get("maxWidth", Infinity);
                        if (w > maxWidth) {
                            availableWidth -= maxWidth;
                            totalPercent -= childWidth.value;
                        }
                    }
                    else {
                        if (!$type.isNumber(childWidth)) {
                            childWidth = child.width();
                        }
                        availableWidth -= childWidth + child.get("marginLeft", 0) + child.get("marginRight", 0);
                    }
                }
            });
            if (availableWidth > 0) {
                eachChildren(container, function (child) {
                    if (child.get("position") == "relative") {
                        var childWidth = child.get("width");
                        if (childWidth instanceof Percent) {
                            var privateWidth = availableWidth * childWidth.value / totalPercent - child.get("marginLeft", 0) - child.get("marginRight", 0);
                            var minWidth = child.get("minWidth", -Infinity);
                            var maxWidth = child.get("maxWidth", Infinity);
                            privateWidth = Math.min(Math.max(minWidth, privateWidth), maxWidth);
                            child.setPrivate("width", privateWidth);
                        }
                    }
                });
            }
            var prevX = paddingLeft;
            eachChildren(container, function (child) {
                if (child.get("position") == "relative") {
                    var bounds = child.adjustedLocalBounds();
                    var marginLeft = child.get("marginLeft", 0);
                    var marginRight = child.get("marginRight", 0);
                    var x = prevX + marginLeft - bounds.left;
                    child.setPrivate("x", x);
                    prevX = x + bounds.right + marginRight;
                }
            });
        }
    });
    Object.defineProperty(HorizontalLayout, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "HorizontalLayout"
    });
    Object.defineProperty(HorizontalLayout, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Layout.classNames.concat([HorizontalLayout.className])
    });
    return HorizontalLayout;
}(Layout));
export { HorizontalLayout };
//# sourceMappingURL=HorizontalLayout.js.map