import { __extends } from "tslib";
import { Text } from "../render/Text";
import { p50, p100 } from "../util/Percent";
import { Container } from "./Container";
import * as $array from "../../core/util/Array";
import * as $type from "../../core/util/Type";
/**
 * Creates a label with support for in-line styling and data bindings.
 *
 * @see {@link https://www.amcharts.com/docs/v5/concepts/common-elements/labels/} for more info
 */
var Label = /** @class */ (function (_super) {
    __extends(Label, _super);
    function Label() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        Object.defineProperty(_this, "_text", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(_this, "_textKeys", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: [
                "text",
                "fill",
                "textAlign",
                "fontFamily",
                "fontSize",
                "fontStyle",
                "fontWeight",
                "fontStyle",
                "fontVariant",
                "textDecoration",
                "shadowColor",
                "shadowBlur",
                "shadowOffsetX",
                "shadowOffsetY",
                "shadowOpacity",
                // "leading",
                // "letterSpacing",
                "lineHeight",
                "baselineRatio",
                //"padding",
                // "stroke",
                // "strokeThickness",
                // "trim",
                // "wordWrap",
                "direction",
                "textBaseline",
                "oversizedBehavior",
                "breakWords",
                "ellipsis",
                "minScale",
                "populateText",
                "role",
                "ignoreFormatting"
            ]
        });
        return _this;
    }
    Object.defineProperty(Label.prototype, "text", {
        /**
         * @ignore Text is not to be used directly
         */
        get: function () {
            return this._text;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Label.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            _super.prototype._afterNew.call(this);
            this._makeText();
            $array.each(this._textKeys, function (property) {
                var propValue = _this.get(property);
                if (propValue != undefined) {
                    _this._text.set(property, propValue);
                }
            });
        }
    });
    Object.defineProperty(Label.prototype, "_makeText", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this._text = this.children.push(Text.new(this._root, {}));
        }
    });
    Object.defineProperty(Label.prototype, "_updateChildren", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            _super.prototype._updateChildren.call(this);
            $array.each(this._textKeys, function (property) {
                _this._text.set(property, _this.get(property));
            });
            if (this.isDirty("maxWidth")) {
                this._setMaxDimentions();
            }
            if (this.isDirty("maxHeight")) {
                this._setMaxDimentions();
            }
            if (this.isDirty("rotation")) {
                this._setMaxDimentions();
            }
            if (this.isDirty("textAlign") || this.isDirty("width")) {
                var textAlign = this.get("textAlign");
                var x = void 0;
                if (this.get("width") != null) {
                    if (textAlign == "right") {
                        x = p100;
                    }
                    else if (textAlign == "center") {
                        x = p50;
                    }
                    else {
                        x = 0;
                    }
                }
                else {
                    if (textAlign == "left" || textAlign == "start") {
                        x = this.get("paddingLeft");
                    }
                    else if (textAlign == "right" || textAlign == "end") {
                        x = -this.get("paddingRight");
                    }
                }
                this.text.set("x", x);
            }
        }
    });
    Object.defineProperty(Label.prototype, "_setMaxDimentions", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var rotation = this.get("rotation");
            var vertical = rotation == 90 || rotation == 270;
            var maxWidth = this.get("maxWidth", Infinity);
            if ($type.isNumber(maxWidth)) {
                this.text.set(vertical ? "maxHeight" : "maxWidth", maxWidth - this.get("paddingLeft", 0) - this.get("paddingRight", 0));
            }
            else {
                this.text.set(vertical ? "maxHeight" : "maxWidth", undefined);
            }
            var maxHeight = this.get("maxHeight", Infinity);
            if ($type.isNumber(maxHeight)) {
                this.text.set(vertical ? "maxWidth" : "maxHeight", maxHeight - this.get("paddingTop", 0) - this.get("paddingBottom", 0));
            }
            else {
                this.text.set(vertical ? "maxWidth" : "maxHeight", undefined);
            }
        }
    });
    Object.defineProperty(Label.prototype, "_setDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            _super.prototype._setDataItem.call(this, dataItem);
            this._markDirtyKey("text");
            if (this.text.get("populateText")) {
                this.text.markDirtyText();
            }
        }
    });
    /**
     * Returns text with populated placeholders and formatting if `populateText` is
     * set to `true`.
     *
     * @return Populated text
     */
    Object.defineProperty(Label.prototype, "getText", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            return this._text._getText();
        }
    });
    Object.defineProperty(Label, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "Label"
    });
    Object.defineProperty(Label, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Container.classNames.concat([Label.className])
    });
    return Label;
}(Container));
export { Label };
//# sourceMappingURL=Label.js.map