import { __extends } from "tslib";
import { Series } from "./Series";
import { Container } from "../../core/render/Container";
import { Label } from "../../core/render/Label";
import { RoundedRectangle } from "../../core/render/RoundedRectangle";
import { Template } from "../../core/util/Template";
import { ListTemplate } from "../../core/util/List";
import * as $utils from "../../core/util/Utils";
/**
 * A universal legend control.
 *
 * @important
 * @see {@link https://www.amcharts.com/docs/v5/concepts/legend/} for more info
 */
var Legend = /** @class */ (function (_super) {
    __extends(Legend, _super);
    function Legend() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * List of all [[Container]] elements for legend items.
         *
         * @default new ListTemplate<Container>
         */
        Object.defineProperty(_this, "itemContainers", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: new ListTemplate(Template.new({}), function () { return Container._new(_this._root, {
                themeTags: $utils.mergeTags(_this.itemContainers.template.get("themeTags", []), ["legend", "item"]),
                themeTagsSelf: $utils.mergeTags(_this.itemContainers.template.get("themeTagsSelf", []), ["itemcontainer"]),
                background: RoundedRectangle.new(_this._root, {
                    themeTags: $utils.mergeTags(_this.itemContainers.template.get("themeTags", []), ["legend", "item", "background"]),
                    themeTagsSelf: $utils.mergeTags(_this.itemContainers.template.get("themeTagsSelf", []), ["itemcontainer"])
                })
            }, [_this.itemContainers.template]); })
        });
        /**
         * List of legend marker elements.
         *
         * @default new ListTemplate<Container>
         */
        Object.defineProperty(_this, "markers", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: new ListTemplate(Template.new({}), function () { return Container._new(_this._root, {
                themeTags: $utils.mergeTags(_this.markers.template.get("themeTags", []), ["legend", "marker"])
            }, [_this.markers.template]); })
        });
        /**
         * List of legend label elements.
         *
         * @default new ListTemplate<Label>
         */
        Object.defineProperty(_this, "labels", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: new ListTemplate(Template.new({}), function () { return Label._new(_this._root, {
                themeTags: $utils.mergeTags(_this.labels.template.get("themeTags", []), ["legend", "label"])
            }, [_this.labels.template]); })
        });
        /**
         * List of legend value label elements.
         *
         * @default new ListTemplate<label>
         */
        Object.defineProperty(_this, "valueLabels", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: new ListTemplate(Template.new({}), function () { return Label._new(_this._root, {
                themeTags: $utils.mergeTags(_this.valueLabels.template.get("themeTags", []), ["legend", "label", "value"])
            }, [_this.valueLabels.template]); })
        });
        /**
         * List of rectangle elements used for default legend markers.
         *
         * @default new ListTemplate<RoundedRectangle>
         */
        Object.defineProperty(_this, "markerRectangles", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: new ListTemplate(Template.new({}), function () { return RoundedRectangle._new(_this._root, {
                themeTags: $utils.mergeTags(_this.markerRectangles.template.get("themeTags", []), ["legend", "marker", "rectangle"])
            }, [_this.markerRectangles.template]); })
        });
        return _this;
    }
    Object.defineProperty(Legend.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this._settings.themeTags = $utils.mergeTags(this._settings.themeTags, ["legend"]);
            this.fields.push("name", "stroke", "fill");
            _super.prototype._afterNew.call(this);
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(Legend.prototype, "makeItemContainer", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            var itemContainer = this.children.push(this.itemContainers.make());
            itemContainer._setDataItem(dataItem);
            this.itemContainers.push(itemContainer);
            itemContainer.states.create("disabled", {});
            return itemContainer;
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(Legend.prototype, "makeMarker", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var marker = this.markers.make();
            this.markers.push(marker);
            marker.states.create("disabled", {});
            return marker;
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(Legend.prototype, "makeLabel", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var label = this.labels.make();
            label.states.create("disabled", {});
            return label;
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(Legend.prototype, "makeValueLabel", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var valueLabel = this.valueLabels.make();
            valueLabel.states.create("disabled", {});
            return valueLabel;
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(Legend.prototype, "makeMarkerRectangle", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var markerRectangle = this.markerRectangles.make();
            markerRectangle.states.create("disabled", {});
            return markerRectangle;
        }
    });
    Object.defineProperty(Legend.prototype, "processDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            var _this = this;
            _super.prototype.processDataItem.call(this, dataItem);
            var itemContainer = this.makeItemContainer(dataItem);
            var nameField = this.get("nameField");
            var fillField = this.get("fillField");
            var strokeField = this.get("strokeField");
            if (itemContainer) {
                var clickTarget = this.get("clickTarget", "itemContainer");
                var item_1 = dataItem.dataContext;
                if (item_1 && item_1.set) {
                    item_1.set("legendDataItem", dataItem);
                }
                itemContainer._setDataItem(dataItem);
                dataItem.set("itemContainer", itemContainer);
                var marker = this.makeMarker();
                if (marker) {
                    itemContainer.children.push(marker);
                    marker._setDataItem(dataItem);
                    dataItem.set("marker", marker);
                    var useDefaultMarker = this.get("useDefaultMarker");
                    var markerRectangle_1 = marker.children.push(this.makeMarkerRectangle());
                    var fill = dataItem.get("fill");
                    var stroke = dataItem.get("stroke");
                    dataItem.set("markerRectangle", markerRectangle_1);
                    if (item_1 && item_1.get) {
                        fill = item_1.get(fillField, fill);
                        stroke = item_1.get(strokeField, stroke);
                    }
                    if (!stroke) {
                        stroke = fill;
                    }
                    if (!useDefaultMarker) {
                        if (item_1 && item_1.createLegendMarker) {
                            item_1.createLegendMarker();
                        }
                    }
                    else {
                        if (item_1.on) {
                            item_1.on(fillField, function () {
                                markerRectangle_1.set("fill", item_1.get(fillField));
                            });
                            item_1.on(strokeField, function () {
                                markerRectangle_1.set("stroke", item_1.get(strokeField));
                            });
                        }
                    }
                    markerRectangle_1.setAll({ fill: fill, stroke: stroke });
                    // this solves if template field is set on slice
                    var component = item_1.component;
                    if (component && component.updateLegendMarker) {
                        component.updateLegendMarker(item_1);
                    }
                }
                var label_1 = this.makeLabel();
                if (label_1) {
                    itemContainer.children.push(label_1);
                    label_1._setDataItem(dataItem);
                    dataItem.set("label", label_1);
                    label_1.text.on("text", function () {
                        itemContainer.set("ariaLabel", label_1.text._getText() + "; " + _this._t("Press ENTER to toggle"));
                    });
                    if (item_1 && item_1.get) {
                        dataItem.set("name", item_1.get(nameField));
                    }
                    var name_1 = dataItem.get("name");
                    if (name_1) {
                        label_1.set("text", name_1);
                    }
                }
                var valueLabel = this.makeValueLabel();
                if (valueLabel) {
                    itemContainer.children.push(valueLabel);
                    valueLabel._setDataItem(dataItem);
                    dataItem.set("valueLabel", valueLabel);
                }
                if (item_1 && item_1.show) {
                    this._disposers.push(item_1.on("visible", function (visible) {
                        itemContainer.set("disabled", !visible);
                    }));
                    if (!item_1.get("visible")) {
                        itemContainer.set("disabled", true);
                    }
                    if (clickTarget != "none") {
                        var clickContainer = itemContainer;
                        if (clickTarget == "marker") {
                            clickContainer = marker;
                        }
                        this._addClickEvents(clickContainer, item_1, dataItem);
                    }
                }
            }
        }
    });
    Object.defineProperty(Legend.prototype, "_addClickEvents", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (container, item, dataItem) {
            var _this = this;
            container.set("cursorOverStyle", "pointer");
            container.events.on("pointerover", function () {
                var component = item.component;
                if (component && component.hoverDataItem) {
                    component.hoverDataItem(item);
                }
            });
            container.events.on("pointerout", function () {
                var component = item.component;
                if (component && component.hoverDataItem) {
                    component.unhoverDataItem(item);
                }
            });
            container.events.on("click", function () {
                var labelText = dataItem.get("label").text._getText();
                if (item.show && item.isHidden && (item.isHidden() || item.get("visible") === false)) {
                    item.show();
                    container.set("disabled", false);
                    _this._root.readerAlert(_this._t("%1 shown", _this._root.locale, labelText));
                }
                else if (item.hide) {
                    item.hide();
                    container.set("disabled", true);
                    _this._root.readerAlert(_this._t("%1 hidden", _this._root.locale, labelText));
                }
            });
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(Legend.prototype, "disposeDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            var itemContainer = dataItem.get("itemContainer");
            if (itemContainer) {
                this.itemContainers.removeValue(itemContainer);
                itemContainer.dispose();
            }
            var marker = dataItem.get("marker");
            if (marker) {
                this.markers.removeValue(marker);
                marker.dispose();
            }
            var markerRectangle = dataItem.get("markerRectangle");
            if (markerRectangle) {
                this.markerRectangles.removeValue(markerRectangle);
                markerRectangle.dispose();
            }
            var label = dataItem.get("label");
            if (label) {
                this.labels.removeValue(label);
                label.dispose();
            }
            var valueLabel = dataItem.get("valueLabel");
            if (valueLabel) {
                this.valueLabels.removeValue(valueLabel);
                valueLabel.dispose();
            }
        }
    });
    Object.defineProperty(Legend, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "Legend"
    });
    Object.defineProperty(Legend, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Series.classNames.concat([Legend.className])
    });
    return Legend;
}(Series));
export { Legend };
//# sourceMappingURL=Legend.js.map