import { __extends } from "tslib";
import { Sprite } from "./Sprite";
import * as $type from "../util/Type";
/**
 * Displays an image.
 *
 * @see {@link https://www.amcharts.com/docs/v5/concepts/common-elements/images/} for more info
 * @important
 */
var Picture = /** @class */ (function (_super) {
    __extends(Picture, _super);
    function Picture() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        Object.defineProperty(_this, "_display", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: _this._root._renderer.makePicture(undefined)
        });
        return _this;
    }
    Object.defineProperty(Picture.prototype, "_changed", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._changed.call(this);
            if (this.isDirty("width")) {
                var width = this.get("width");
                this._display.width = $type.isNumber(width) ? width : undefined;
            }
            if (this.isDirty("height")) {
                var height = this.get("height");
                this._display.height = $type.isNumber(height) ? height : undefined;
            }
            if (this.isDirty("shadowColor")) {
                this._display.clear();
                var shadowColor = this.get("shadowColor");
                this._display.shadowColor = shadowColor == null ? undefined : shadowColor;
            }
            if (this.isDirty("shadowBlur")) {
                this._display.clear();
                this._display.shadowBlur = this.get("shadowBlur");
            }
            if (this.isDirty("shadowOffsetX")) {
                this._display.clear();
                this._display.shadowOffsetX = this.get("shadowOffsetX");
            }
            if (this.isDirty("shadowOffsetY")) {
                this._display.clear();
                this._display.shadowOffsetY = this.get("shadowOffsetY");
            }
            if (this.isDirty("shadowOpacity")) {
                this._display.clear();
                this._display.shadowOpacity = this.get("shadowOpacity");
            }
            if (this.isDirty("src")) {
                this._display.clear();
                this._load();
            }
        }
    });
    Object.defineProperty(Picture.prototype, "_load", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            var src = this.get("src");
            if (src) {
                var image_1 = new Image();
                //image.crossOrigin = "Anonymous";
                image_1.src = src;
                image_1.decode().then(function () {
                    _this._display.image = image_1;
                    _this._updateSize();
                }).catch(function (_error) {
                    // TODO: maybe raise error?
                });
            }
        }
    });
    Object.defineProperty(Picture.prototype, "_updateSize", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._updateSize.call(this);
            var image = this._display.image;
            if (image) {
                var w = this.getPrivate("width", this.get("width"));
                var h = this.getPrivate("height", this.get("height"));
                var r = image.width && image.height ? image.width / image.height : 0;
                if ($type.isNumber(w) && $type.isNumber(h)) {
                    this._display.width = w;
                    this._display.height = h;
                }
                else if ($type.isNumber(w) && r) {
                    h = w / r;
                }
                else if ($type.isNumber(h) && r) {
                    w = h * r;
                }
                else {
                    w = image.width;
                    h = image.height;
                }
                if ($type.isNumber(w)) {
                    this._display.width = w;
                }
                if ($type.isNumber(h)) {
                    this._display.height = h;
                }
                this.markDirtyBounds();
                this.markDirty();
            }
        }
    });
    Object.defineProperty(Picture, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "Picture"
    });
    Object.defineProperty(Picture, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Sprite.classNames.concat([Picture.className])
    });
    return Picture;
}(Sprite));
export { Picture };
//# sourceMappingURL=Picture.js.map