import { __extends } from "tslib";
import { Graphics } from "./Graphics";
import * as $math from "../util/Math";
/**
 * Draws a rectangle with a pointer.
 *
 * @see {@link https://www.amcharts.com/docs/v5/concepts/common-elements/graphics/} for more info
 * @important
 */
var PointedRectangle = /** @class */ (function (_super) {
    __extends(PointedRectangle, _super);
    function PointedRectangle() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(PointedRectangle.prototype, "_beforeChanged", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._beforeChanged.call(this);
            if (this.isDirty("pointerBaseWidth") || this.isDirty("cornerRadius") || this.isDirty("pointerLength") || this.isDirty("pointerX") || this.isDirty("pointerY") || this.isDirty("width") || this.isDirty("height")) {
                this._clear = true;
            }
        }
    });
    Object.defineProperty(PointedRectangle.prototype, "_changed", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._changed.call(this);
            if (this._clear) {
                this.markDirtyBounds();
                var w = this.width();
                var h = this.height();
                if (w > 0 && h > 0) {
                    var cr = this.get("cornerRadius", 8);
                    cr = $math.fitToRange(cr, 0, Math.min(w / 2, h / 2));
                    var x = this.get("pointerX", 0);
                    var y = this.get("pointerY", 0);
                    var bwh = this.get("pointerBaseWidth", 15) / 2;
                    // corner coordinates
                    // top left
                    var xtl = 0;
                    var ytl = 0;
                    // top right
                    var xtr = w;
                    var ytr = 0;
                    // bottom right
                    var xbr = w;
                    var ybr = h;
                    // bottom left
                    var xbl = 0;
                    var ybl = h;
                    // find stem base side: http://$math.stackexchange.com/questions/274712/calculate-on-which-side-of-straign-line-is-dot-located
                    // d=(x−x1)(y2−y1)−(y−y1)(x2−x1)
                    var d1 = (x - xtl) * (ybr - ytl) - (y - ytl) * (xbr - xtl);
                    var d2 = (x - xbl) * (ytr - ybl) - (y - ybl) * (xtr - xbl);
                    var display = this._display;
                    // top
                    display.moveTo(cr, 0);
                    if (d1 > 0 && d2 > 0) {
                        var stemX = Math.round($math.fitToRange(x, cr + bwh, w - bwh - cr));
                        y = $math.fitToRange(y, -Infinity, 0);
                        display.lineTo(stemX - bwh, 0);
                        display.lineTo(x, y);
                        display.lineTo(stemX + bwh, 0);
                    }
                    display.lineTo(w - cr, 0);
                    display.arcTo(w, 0, w, cr, cr);
                    // right
                    if (d1 > 0 && d2 < 0) {
                        var stemY = Math.round($math.fitToRange(y, cr + bwh, h - bwh - cr));
                        x = $math.fitToRange(x, w, Infinity);
                        display.lineTo(w, cr);
                        display.lineTo(w, stemY - bwh);
                        display.lineTo(x, y);
                        display.lineTo(w, stemY + bwh);
                    }
                    display.lineTo(w, h - cr);
                    display.arcTo(w, h, w - cr, h, cr);
                    // bottom
                    if (d1 < 0 && d2 < 0) {
                        var stemX = Math.round($math.fitToRange(x, cr + bwh, w - bwh - cr));
                        y = $math.fitToRange(y, h, Infinity);
                        display.lineTo(w - cr, h);
                        display.lineTo(stemX + bwh, h);
                        display.lineTo(x, y);
                        display.lineTo(stemX - bwh, h);
                    }
                    display.lineTo(cr, h);
                    display.arcTo(0, h, 0, h - cr, cr);
                    // left
                    if (d1 < 0 && d2 > 0) {
                        var stemY = Math.round($math.fitToRange(y, cr + bwh, h - cr - bwh));
                        x = $math.fitToRange(x, -Infinity, 0);
                        display.lineTo(0, h - cr);
                        display.lineTo(0, stemY + bwh);
                        display.lineTo(x, y);
                        display.lineTo(0, stemY - bwh);
                    }
                    display.lineTo(0, cr);
                    display.arcTo(0, 0, cr, 0, cr);
                }
            }
        }
    });
    Object.defineProperty(PointedRectangle, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "PointedRectangle"
    });
    Object.defineProperty(PointedRectangle, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Graphics.classNames.concat([PointedRectangle.className])
    });
    return PointedRectangle;
}(Graphics));
export { PointedRectangle };
//# sourceMappingURL=PointedRectangle.js.map