import { __extends } from "tslib";
import { Graphics } from "./Graphics";
/**
 * Draws a rectangle.
 *
 * @see {@link https://www.amcharts.com/docs/v5/concepts/common-elements/graphics/} for more info
 * @important
 */
var Rectangle = /** @class */ (function (_super) {
    __extends(Rectangle, _super);
    function Rectangle() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(Rectangle.prototype, "_beforeChanged", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._beforeChanged.call(this);
            if (this.isDirty("width") || this.isDirty("height") || this.isPrivateDirty("width") || this.isPrivateDirty("height")) {
                this._clear = true;
            }
        }
    });
    Object.defineProperty(Rectangle.prototype, "_changed", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._changed.call(this);
            if (this._clear && !this.get("draw")) {
                this._draw();
            }
        }
    });
    Object.defineProperty(Rectangle.prototype, "_draw", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this._display.drawRect(0, 0, this.width(), this.height());
        }
    });
    Object.defineProperty(Rectangle.prototype, "_updateSize", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this.markDirty();
            this._clear = true;
        }
    });
    Object.defineProperty(Rectangle, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "Rectangle"
    });
    Object.defineProperty(Rectangle, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Graphics.classNames.concat([Rectangle.className])
    });
    return Rectangle;
}(Graphics));
export { Rectangle };
//# sourceMappingURL=Rectangle.js.map