import { __extends } from "tslib";
import * as $type from "../util/Type";
import * as $math from "../util/Math";
import * as $utils from "../util/Utils";
import { Rectangle } from "./Rectangle";
/**
 * Draws a rectangle with rounded corners.
 *
 * @see {@link https://www.amcharts.com/docs/v5/concepts/common-elements/graphics/} for more info
 * @important
 */
var RoundedRectangle = /** @class */ (function (_super) {
    __extends(RoundedRectangle, _super);
    function RoundedRectangle() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(RoundedRectangle.prototype, "_beforeChanged", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._beforeChanged.call(this);
            if (this.isDirty("cornerRadiusTL") || this.isDirty("cornerRadiusTR") || this.isDirty("cornerRadiusBR") || this.isDirty("cornerRadiusBL")) {
                this._clear = true;
            }
        }
    });
    Object.defineProperty(RoundedRectangle.prototype, "_draw", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var width = this.width();
            var height = this.height();
            var w = width;
            var h = height;
            var wSign = w / Math.abs(width);
            var hSign = h / Math.abs(height);
            if ($type.isNumber(w) && $type.isNumber(h)) {
                var minSide = Math.min(w, h) / 2;
                var crtl = $utils.relativeToValue(this.get("cornerRadiusTL", 8), minSide);
                var crtr = $utils.relativeToValue(this.get("cornerRadiusTR", 8), minSide);
                var crbr = $utils.relativeToValue(this.get("cornerRadiusBR", 8), minSide);
                var crbl = $utils.relativeToValue(this.get("cornerRadiusBL", 8), minSide);
                var maxcr = Math.min(Math.abs(w / 2), Math.abs(h / 2));
                crtl = $math.fitToRange(crtl, 0, maxcr);
                crtr = $math.fitToRange(crtr, 0, maxcr);
                crbr = $math.fitToRange(crbr, 0, maxcr);
                crbl = $math.fitToRange(crbl, 0, maxcr);
                this._display.moveTo(crtl * wSign, 0);
                this._display.lineTo(w - crtr * wSign, 0);
                if (crtr > 0) {
                    this._display.arcTo(w, 0, w, crtr * hSign, crtr);
                }
                this._display.lineTo(w, h - crbr * hSign);
                if (crbr > 0) {
                    this._display.arcTo(w, h, w - crbr * wSign, h, crbr);
                }
                this._display.lineTo(crbl * wSign, h);
                if (crbl > 0) {
                    this._display.arcTo(0, h, 0, h - crbl * hSign, crbl);
                }
                this._display.lineTo(0, crtl * hSign);
                if (crtl > 0) {
                    this._display.arcTo(0, 0, crtl * wSign, 0, crtl);
                }
            }
        }
    });
    Object.defineProperty(RoundedRectangle, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "RoundedRectangle"
    });
    Object.defineProperty(RoundedRectangle, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Rectangle.classNames.concat([RoundedRectangle.className])
    });
    return RoundedRectangle;
}(Rectangle));
export { RoundedRectangle };
//# sourceMappingURL=RoundedRectangle.js.map