import { __awaiter, __extends, __generator } from "tslib";
import { Component } from "../../core/render/Component";
import { List } from "../../core/util/List";
import { Color } from "../../core/util/Color";
import { percentInterpolate } from "../../core/util/Animation";
import { Percent } from "../../core/util/Percent";
import * as $array from "../../core/util/Array";
import * as $type from "../../core/util/Type";
import * as $time from "../../core/util/Time";
import { p100 } from "../../core/util/Percent";
import { Container } from "../../core/render/Container";
import { Label } from "../../core/render/Label";
/**
 * A base class for all series.
 */
var Series = /** @class */ (function (_super) {
    __extends(Series, _super);
    function Series() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        Object.defineProperty(_this, "_aggregatesCalculated", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: false
        });
        Object.defineProperty(_this, "_selectionAggregatesCalculated", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: false
        });
        Object.defineProperty(_this, "_dataProcessed", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: false
        });
        Object.defineProperty(_this, "_psi", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        Object.defineProperty(_this, "_pei", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        /**
         * A chart series belongs to.
         */
        Object.defineProperty(_this, "chart", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        /**
         * List of bullets to use for the series.
         *
         * @see {@link https://www.amcharts.com/docs/v5/concepts/common-elements/bullets/} for more info
         */
        Object.defineProperty(_this, "bullets", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: new List()
        });
        /**
         * A [[Container]] series' bullets are stored in.
         *
         * @default Container.new()
         */
        Object.defineProperty(_this, "bulletsContainer", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: Container.new(_this._root, { width: p100, height: p100, position: "absolute" })
        });
        return _this;
    }
    Object.defineProperty(Series.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            this.valueFields.push("value");
            _super.prototype._afterNew.call(this);
            this.setPrivate("customData", {});
            this._disposers.push(this.bullets.events.onAll(function (change) {
                if (change.type === "clear") {
                    _this._handleBullets(_this.dataItems);
                }
                else if (change.type === "push") {
                    _this._handleBullets(_this.dataItems);
                }
                else if (change.type === "setIndex") {
                    _this._handleBullets(_this.dataItems);
                }
                else if (change.type === "insertIndex") {
                    _this._handleBullets(_this.dataItems);
                }
                else if (change.type === "removeIndex") {
                    _this._handleBullets(_this.dataItems);
                }
                else if (change.type === "moveIndex") {
                    _this._handleBullets(_this.dataItems);
                }
                else {
                    throw new Error("Unknown IListEvent type");
                }
            }));
        }
    });
    Object.defineProperty(Series.prototype, "_dispose", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this.bulletsContainer.dispose(); // can be in a different parent
            _super.prototype._dispose.call(this);
        }
    });
    Object.defineProperty(Series.prototype, "startIndex", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var len = this.dataItems.length;
            return Math.min(this.getPrivate("startIndex", 0), len);
        }
    });
    Object.defineProperty(Series.prototype, "endIndex", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var len = this.dataItems.length;
            return Math.min(this.getPrivate("endIndex", len), len);
        }
    });
    Object.defineProperty(Series.prototype, "_handleBullets", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItems) {
            $array.each(dataItems, function (dataItem) {
                var bullets = dataItem.bullets;
                if (bullets) {
                    $array.each(bullets, function (bullet) {
                        bullet.dispose();
                    });
                    dataItem.bullets = undefined;
                }
            });
            this.markDirtyValues();
        }
    });
    /**
     * Looks up and returns a data item by its ID.
     *
     * @param   id  ID
     * @return      Data item
     */
    Object.defineProperty(Series.prototype, "getDataItemById", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (id) {
            return $array.find(this.dataItems, function (dataItem) {
                return dataItem.get("id") == id;
            });
        }
    });
    Object.defineProperty(Series.prototype, "_makeBullets", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            var _this = this;
            if (this._shouldMakeBullet(dataItem)) {
                dataItem.bullets = [];
                this.bullets.each(function (bulletFunction) {
                    _this._makeBullet(dataItem, bulletFunction);
                });
            }
        }
    });
    Object.defineProperty(Series.prototype, "_shouldMakeBullet", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (_dataItem) {
            return true;
        }
    });
    Object.defineProperty(Series.prototype, "_makeBullet", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, bulletFunction, index) {
            var bullet = bulletFunction(this._root, this, dataItem);
            if (bullet) {
                var sprite = bullet.get("sprite");
                if (sprite) {
                    sprite._setDataItem(dataItem);
                    sprite.setRaw("position", "absolute");
                    this.bulletsContainer.children.push(sprite);
                }
                bullet._index = index;
                bullet.series = this;
                dataItem.bullets.push(bullet);
            }
            return bullet;
        }
    });
    Object.defineProperty(Series.prototype, "_clearDirty", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._clearDirty.call(this);
            this._aggregatesCalculated = false;
            this._selectionAggregatesCalculated = false;
        }
    });
    Object.defineProperty(Series.prototype, "_prepareChildren", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._prepareChildren.call(this);
            var startIndex = this.startIndex();
            var endIndex = this.endIndex();
            var calculateAggregates = this.get("calculateAggregates");
            if (calculateAggregates) {
                if (this._valuesDirty && !this._dataProcessed) {
                    if (!this._aggregatesCalculated) {
                        this._calculateAggregates(0, this.dataItems.length);
                        this._aggregatesCalculated = true;
                    }
                }
                if ((this._psi != startIndex || this._pei != endIndex) && !this._selectionAggregatesCalculated) {
                    if (startIndex === 0 && endIndex === this.dataItems.length && this._aggregatesCalculated) {
                        // void
                    }
                    else {
                        this._calculateAggregates(startIndex, endIndex);
                    }
                    this._selectionAggregatesCalculated = true;
                }
            }
            if (this.isDirty("tooltip")) {
                var tooltip = this.get("tooltip");
                if (tooltip) {
                    tooltip.hide(0);
                    tooltip.set("tooltipTarget", this);
                }
            }
            if (this.isDirty("fill") || this.isDirty("stroke")) {
                var markerRectangle = void 0;
                var legendDataItem = this.get("legendDataItem");
                if (legendDataItem) {
                    markerRectangle = legendDataItem.get("markerRectangle");
                    if (markerRectangle) {
                        if (this.isDirty("stroke")) {
                            var stroke = this.get("stroke");
                            markerRectangle.set("stroke", stroke);
                        }
                        if (this.isDirty("fill")) {
                            var fill = this.get("fill");
                            markerRectangle.set("fill", fill);
                        }
                    }
                }
                this.updateLegendMarker(undefined);
            }
            if (this.bullets.length > 0) {
                var startIndex_1 = this.startIndex();
                var endIndex_1 = this.endIndex();
                for (var i = startIndex_1; i < endIndex_1; i++) {
                    var dataItem = this.dataItems[i];
                    if (!dataItem.bullets) {
                        this._makeBullets(dataItem);
                    }
                }
            }
        }
    });
    Object.defineProperty(Series.prototype, "_calculateAggregates", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (startIndex, endIndex) {
            var _this = this;
            var fields = this._valueFields;
            if (!fields) {
                throw new Error("No value fields are set for the series.");
            }
            var sum = {};
            var absSum = {};
            var count = {};
            var low = {};
            var high = {};
            var open = {};
            var close = {};
            var average = {};
            var previous = {};
            $array.each(fields, function (key) {
                sum[key] = 0;
                absSum[key] = 0;
                count[key] = 0;
            });
            $array.each(fields, function (key) {
                var change = key + "Change";
                var changePercent = key + "ChangePercent";
                var changePrevious = key + "ChangePrevious";
                var changePreviousPercent = key + "ChangePreviousPercent";
                var changeSelection = key + "ChangeSelection";
                var ChangeSelectionPercent = key + "ChangeSelectionPercent";
                for (var i = startIndex; i < endIndex; i++) {
                    var dataItem = _this.dataItems[i];
                    var value = dataItem.get(key);
                    if (value != null) {
                        count[key]++;
                        sum[key] += value;
                        absSum[key] += Math.abs(value);
                        average[key] = sum[key] / count[key];
                        if (low[key] > value || low[key] == null) {
                            low[key] = value;
                        }
                        if (high[key] < value || high[key] == null) {
                            high[key] = value;
                        }
                        close[key] = value;
                        if (open[key] == null) {
                            open[key] = value;
                            previous[key] = value;
                        }
                        if (startIndex === 0) {
                            dataItem.setRaw((change), value - open[key]);
                            dataItem.setRaw((changePercent), (value - open[key]) / open[key] * 100);
                        }
                        dataItem.setRaw((changePrevious), value - previous[key]);
                        dataItem.setRaw((changePreviousPercent), (value - previous[key]) / previous[key] * 100);
                        dataItem.setRaw((changeSelection), value - open[key]);
                        dataItem.setRaw((ChangeSelectionPercent), (value - open[key]) / open[key] * 100);
                        previous[key] = value;
                    }
                }
            });
            $array.each(fields, function (key) {
                _this.setPrivate((key + "AverageSelection"), average[key]);
                _this.setPrivate((key + "CountSelection"), count[key]);
                _this.setPrivate((key + "SumSelection"), sum[key]);
                _this.setPrivate((key + "AbsoluteSumSelection"), absSum[key]);
                _this.setPrivate((key + "LowSelection"), low[key]);
                _this.setPrivate((key + "HighSelection"), high[key]);
                _this.setPrivate((key + "OpenSelection"), open[key]);
                _this.setPrivate((key + "CloseSelection"), close[key]);
            });
            if (startIndex === 0 && endIndex === this.dataItems.length) {
                $array.each(fields, function (key) {
                    _this.setPrivate((key + "Average"), average[key]);
                    _this.setPrivate((key + "Count"), count[key]);
                    _this.setPrivate((key + "Sum"), sum[key]);
                    _this.setPrivate((key + "AbsoluteSum"), absSum[key]);
                    _this.setPrivate((key + "Low"), low[key]);
                    _this.setPrivate((key + "High"), high[key]);
                    _this.setPrivate((key + "Open"), open[key]);
                    _this.setPrivate((key + "Close"), close[key]);
                });
            }
        }
    });
    Object.defineProperty(Series.prototype, "_updateChildren", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var _this = this;
            _super.prototype._updateChildren.call(this);
            this._psi = this.startIndex();
            this._pei = this.endIndex();
            if (this.isDirty("visible")) {
                this.bulletsContainer.set("visible", this.get("visible"));
            }
            // Apply heat rules
            if (this._valuesDirty && this.get("heatRules") != null) {
                var rules = this.get("heatRules", []);
                $array.each(rules, function (rule) {
                    var minValue = rule.minValue || _this.getPrivate((rule.dataField + "Low")) || 0;
                    var maxValue = rule.maxValue || _this.getPrivate((rule.dataField + "High")) || 0;
                    $array.each(rule.target._entities, function (target) {
                        var value = target.dataItem.get(rule.dataField);
                        if (!$type.isNumber(value)) {
                            return;
                        }
                        var percent;
                        if (rule.logarithmic) {
                            percent = (Math.log(value) * Math.LOG10E - Math.log(minValue) * Math.LOG10E) / ((Math.log(maxValue) * Math.LOG10E - Math.log(minValue) * Math.LOG10E));
                        }
                        else {
                            percent = (value - minValue) / (maxValue - minValue);
                        }
                        if ($type.isNumber(value) && (!$type.isNumber(percent) || Math.abs(percent) == Infinity)) {
                            percent = 0.5;
                        }
                        // fixes problems if all values are the same
                        var propertyValue;
                        if ($type.isNumber(rule.min)) {
                            propertyValue = rule.min + (rule.max - rule.min) * percent;
                        }
                        else if (rule.min instanceof Color) {
                            propertyValue = Color.interpolate(percent, rule.min, rule.max);
                        }
                        else if (rule.min instanceof Percent) {
                            propertyValue = percentInterpolate(percent, rule.min, rule.max);
                        }
                        if (rule.customFunction) {
                            rule.customFunction.call(_this, target, minValue, maxValue, value);
                        }
                        else {
                            target.set(rule.key, propertyValue);
                        }
                    });
                });
            }
            if (this.bullets.length > 0) {
                var count = this.dataItems.length;
                var startIndex = this.startIndex();
                var endIndex = this.endIndex();
                if (endIndex < count) {
                    endIndex++;
                }
                if (startIndex > 0) {
                    startIndex--;
                }
                for (var i = 0; i < startIndex; i++) {
                    this._hideBullets(this.dataItems[i]);
                }
                for (var i = startIndex; i < endIndex; i++) {
                    this._positionBullets(this.dataItems[i]);
                }
                for (var i = endIndex; i < count; i++) {
                    this._hideBullets(this.dataItems[i]);
                }
            }
        }
    });
    Object.defineProperty(Series.prototype, "_positionBullets", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            var _this = this;
            if (dataItem.bullets) {
                $array.each(dataItem.bullets, function (bullet) {
                    _this._positionBullet(bullet);
                    var sprite = bullet.get("sprite");
                    if (bullet.get("dynamic")) {
                        if (sprite) {
                            sprite._markDirtyKey("fill");
                            sprite.markDirtySize();
                        }
                        if (sprite instanceof Container) {
                            sprite.walkChildren(function (child) {
                                child._markDirtyKey("fill");
                                child.markDirtySize();
                            });
                        }
                    }
                    if (sprite instanceof Label && sprite.get("populateText")) {
                        sprite.text.markDirtyText();
                    }
                });
            }
        }
    });
    Object.defineProperty(Series.prototype, "_hideBullets", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            if (dataItem.bullets) {
                $array.each(dataItem.bullets, function (bullet) {
                    var sprite = bullet.get("sprite");
                    if (sprite) {
                        sprite.setPrivate("visible", false);
                    }
                });
            }
        }
    });
    Object.defineProperty(Series.prototype, "_positionBullet", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (_bullet) {
        }
    });
    Object.defineProperty(Series.prototype, "_placeBulletsContainer", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (chart) {
            chart.bulletsContainer.children.moveValue(this.bulletsContainer);
        }
    });
    Object.defineProperty(Series.prototype, "_removeBulletsContainer", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var bulletsContainer = this.bulletsContainer;
            if (bulletsContainer.parent) {
                bulletsContainer.parent.children.removeValue(bulletsContainer);
            }
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(Series.prototype, "disposeDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            var bullets = dataItem.bullets;
            if (bullets) {
                $array.each(bullets, function (bullet) {
                    bullet.dispose();
                });
            }
        }
    });
    Object.defineProperty(Series.prototype, "_getItemReaderLabel", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            return "";
        }
    });
    /**
     * Shows series's data item.
     *
     * @param   dataItem  Data item
     * @param   duration  Animation duration in milliseconds
     * @return            Promise
     */
    Object.defineProperty(Series.prototype, "showDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, duration) {
            return __awaiter(this, void 0, void 0, function () {
                var promises, bullets;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            promises = [_super.prototype.showDataItem.call(this, dataItem, duration)];
                            bullets = dataItem.bullets;
                            if (bullets) {
                                $array.each(bullets, function (bullet) {
                                    promises.push(bullet.get("sprite").show(duration));
                                });
                            }
                            return [4 /*yield*/, Promise.all(promises)];
                        case 1:
                            _a.sent();
                            return [2 /*return*/];
                    }
                });
            });
        }
    });
    /**
     * Hides series's data item.
     *
     * @param   dataItem  Data item
     * @param   duration  Animation duration in milliseconds
     * @return            Promise
     */
    Object.defineProperty(Series.prototype, "hideDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem, duration) {
            return __awaiter(this, void 0, void 0, function () {
                var promises, bullets;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            promises = [_super.prototype.hideDataItem.call(this, dataItem, duration)];
                            bullets = dataItem.bullets;
                            if (bullets) {
                                $array.each(bullets, function (bullet) {
                                    promises.push(bullet.get("sprite").hide(duration));
                                });
                            }
                            return [4 /*yield*/, Promise.all(promises)];
                        case 1:
                            _a.sent();
                            return [2 /*return*/];
                    }
                });
            });
        }
    });
    Object.defineProperty(Series.prototype, "_sequencedShowHide", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (show, duration) {
            return __awaiter(this, void 0, void 0, function () {
                var startIndex_2, endIndex_2;
                var _this = this;
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            if (!this.get("sequencedInterpolation")) return [3 /*break*/, 4];
                            if (!$type.isNumber(duration)) {
                                duration = this.get("interpolationDuration", 0);
                            }
                            if (!(duration > 0)) return [3 /*break*/, 2];
                            startIndex_2 = this.startIndex();
                            endIndex_2 = this.endIndex();
                            return [4 /*yield*/, Promise.all($array.map(this.dataItems, function (dataItem, i) { return __awaiter(_this, void 0, void 0, function () {
                                    var realDuration, delay;
                                    return __generator(this, function (_a) {
                                        switch (_a.label) {
                                            case 0:
                                                realDuration = duration || 0;
                                                if (i < startIndex_2 - 10 || i > endIndex_2 + 10) {
                                                    realDuration = 0;
                                                }
                                                delay = this.get("sequencedDelay", 0) + realDuration / (endIndex_2 - startIndex_2);
                                                return [4 /*yield*/, $time.sleep(delay * (i - startIndex_2))];
                                            case 1:
                                                _a.sent();
                                                if (!show) return [3 /*break*/, 3];
                                                return [4 /*yield*/, this.showDataItem(dataItem, realDuration)];
                                            case 2:
                                                _a.sent();
                                                return [3 /*break*/, 5];
                                            case 3: return [4 /*yield*/, this.hideDataItem(dataItem, realDuration)];
                                            case 4:
                                                _a.sent();
                                                _a.label = 5;
                                            case 5: return [2 /*return*/];
                                        }
                                    });
                                }); }))];
                        case 1:
                            _a.sent();
                            return [3 /*break*/, 4];
                        case 2: return [4 /*yield*/, Promise.all($array.map(this.dataItems, function (dataItem) {
                                if (show) {
                                    return _this.showDataItem(dataItem, 0);
                                }
                                else {
                                    return _this.hideDataItem(dataItem, 0);
                                }
                            }))];
                        case 3:
                            _a.sent();
                            _a.label = 4;
                        case 4: return [2 /*return*/];
                    }
                });
            });
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(Series.prototype, "updateLegendValue", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (dataItem) {
            var legendDataItem = dataItem.get("legendDataItem");
            if (legendDataItem) {
                var valueLabel = legendDataItem.get("valueLabel");
                if (valueLabel) {
                    var text = valueLabel.text;
                    var txt = "";
                    valueLabel._setDataItem(dataItem);
                    txt = this.get("legendValueText", text.get("text", ""));
                    valueLabel.set("text", txt);
                    text.markDirtyText();
                }
                var label = legendDataItem.get("label");
                if (label) {
                    var text = label.text;
                    var txt = "";
                    label._setDataItem(dataItem);
                    txt = this.get("legendLabelText", text.get("text", ""));
                    label.set("text", txt);
                    text.markDirtyText();
                }
            }
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(Series.prototype, "updateLegendMarker", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (_dataItem) {
        }
    });
    Object.defineProperty(Series.prototype, "_onHide", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._onHide.call(this);
            var tooltip = this.getTooltip();
            if (tooltip) {
                tooltip.hide();
            }
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(Series.prototype, "hoverDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (_dataItem) {
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(Series.prototype, "unhoverDataItem", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (_dataItem) {
        }
    });
    Object.defineProperty(Series, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "Series"
    });
    Object.defineProperty(Series, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Component.classNames.concat([Series.className])
    });
    return Series;
}(Component));
export { Series };
//# sourceMappingURL=Series.js.map