import { __extends } from "tslib";
import { Graphics } from "./Graphics";
import * as $type from "../util/Type";
import { Percent } from "../util/Percent";
import { arc } from "d3-shape";
import * as $math from "../util/Math";
/**
 * Draws a slice shape.
 *
 * @see {@link https://www.amcharts.com/docs/v5/concepts/common-elements/graphics/} for more info
 */
var Slice = /** @class */ (function (_super) {
    __extends(Slice, _super);
    function Slice() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /**
         * @ignore
         */
        Object.defineProperty(_this, "ix", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 0
        });
        /**
         * @ignore
         */
        Object.defineProperty(_this, "iy", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: 0
        });
        Object.defineProperty(_this, "_generator", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: arc()
        });
        return _this;
    }
    Object.defineProperty(Slice.prototype, "_getTooltipPoint", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var tooltipX = this.get("tooltipX");
            var tooltipY = this.get("tooltipY");
            var x = 0;
            var y = 0;
            if ($type.isNumber(tooltipX)) {
                x = tooltipX;
            }
            if ($type.isNumber(tooltipY)) {
                y = tooltipY;
            }
            var radius = this.get("radius", 0);
            var innerRadius = this.get("innerRadius", 0);
            var dRadius = this.get("dRadius", 0);
            var dInnerRadius = this.get("dInnerRadius", 0);
            radius += dRadius;
            innerRadius += dInnerRadius;
            if (innerRadius < 0) {
                innerRadius = radius + innerRadius;
            }
            if (tooltipX instanceof Percent) {
                x = this.ix * (innerRadius + (radius - innerRadius) * tooltipX.value);
            }
            if (tooltipY instanceof Percent) {
                y = this.iy * (innerRadius + (radius - innerRadius) * tooltipY.value);
            }
            if (this.get("arc") >= 360 && innerRadius == 0) {
                x = 0;
                y = 0;
            }
            return { x: x, y: y };
        }
    });
    Object.defineProperty(Slice.prototype, "_beforeChanged", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._beforeChanged.call(this);
            if (this.isDirty("radius") || this.isDirty("arc") || this.isDirty("innerRadius") || this.isDirty("startAngle") || this.isDirty("dRadius") || this.isDirty("dInnerRadius") || this.isDirty("cornerRadius")) {
                this._clear = true;
            }
        }
    });
    Object.defineProperty(Slice.prototype, "_changed", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._changed.call(this);
            if (this._clear) {
                var startAngle = this.get("startAngle", 0);
                var arc_1 = this.get("arc", 0);
                var generator = this._generator;
                if (arc_1 < 0) {
                    startAngle = startAngle + arc_1;
                    arc_1 = arc_1 * -1;
                }
                if (arc_1 > 0.1) { // this fixes bug with full circle when arc is very small
                    generator.cornerRadius(this.get("cornerRadius", 0));
                }
                generator.context(this._display);
                var radius = this.get("radius", 0);
                var innerRadius = this.get("innerRadius", 0);
                var dRadius = this.get("dRadius", 0);
                var dInnerRadius = this.get("dInnerRadius", 0);
                radius += dRadius;
                innerRadius += dInnerRadius;
                if (innerRadius < 0) {
                    innerRadius = radius + innerRadius;
                }
                generator({ innerRadius: innerRadius, outerRadius: radius, startAngle: (startAngle + 90) * $math.RADIANS, endAngle: (startAngle + arc_1 + 90) * $math.RADIANS });
                var middleAngle = startAngle + arc_1 / 2;
                this.ix = $math.cos(middleAngle);
                this.iy = $math.sin(middleAngle);
            }
            if (this.isDirty("shiftRadius")) {
                var shiftRadius = this.get("shiftRadius", 0);
                this.setRaw("dx", this.ix * shiftRadius);
                this.setRaw("dy", this.iy * shiftRadius);
                this.markDirtyPosition();
            }
        }
    });
    Object.defineProperty(Slice, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "Slice"
    });
    Object.defineProperty(Slice, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Graphics.classNames.concat([Slice.className])
    });
    return Slice;
}(Graphics));
export { Slice };
//# sourceMappingURL=Slice.js.map