import { __extends } from "tslib";
import { Scrollbar } from "./Scrollbar";
/**
 * A control that allows zooming chart's axes, or other uses requiring range
 * selection.
 */
var Slider = /** @class */ (function (_super) {
    __extends(Slider, _super);
    function Slider() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(Slider.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this._addOrientationClass();
            _super.prototype._afterNew.call(this);
            this.endGrip.setPrivate("visible", false);
            this.thumb.setPrivate("visible", false);
        }
    });
    /**
     * @ignore
     */
    Object.defineProperty(Slider.prototype, "updateGrips", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype.updateGrips.call(this);
            var startGrip = this.startGrip;
            this.endGrip.setAll({ x: startGrip.x(), y: startGrip.y() });
            this.setRaw("end", this.get("start"));
        }
    });
    Object.defineProperty(Slider, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "Slider"
    });
    Object.defineProperty(Slider, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Scrollbar.classNames.concat([Slider.className])
    });
    return Slider;
}(Scrollbar));
export { Slider };
//# sourceMappingURL=Slider.js.map