import { __extends } from "tslib";
import { Graphics } from "./Graphics";
/**
 * Draws a triangle.
 *
 * @see {@link https://www.amcharts.com/docs/v5/concepts/common-elements/graphics/} for more info
 * @important
 */
var Triangle = /** @class */ (function (_super) {
    __extends(Triangle, _super);
    function Triangle() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(Triangle.prototype, "_beforeChanged", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._beforeChanged.call(this);
            if (this.isDirty("width") || this.isDirty("height") || this.isPrivateDirty("width") || this.isPrivateDirty("height")) {
                this._clear = true;
            }
        }
    });
    Object.defineProperty(Triangle.prototype, "_changed", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._changed.call(this);
            if (this._clear && !this.get("draw")) {
                this._draw();
            }
        }
    });
    Object.defineProperty(Triangle.prototype, "_draw", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            var w = this.width();
            var h = this.height();
            var display = this._display;
            display.moveTo(-w / 2, h / 2);
            display.lineTo(0, -h / 2);
            display.lineTo(w / 2, h / 2);
            display.lineTo(-w / 2, h / 2);
        }
    });
    Object.defineProperty(Triangle.prototype, "_updateSize", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            this.markDirty();
            this._clear = true;
        }
    });
    Object.defineProperty(Triangle, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "Triangle"
    });
    Object.defineProperty(Triangle, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Graphics.classNames.concat([Triangle.className])
    });
    return Triangle;
}(Graphics));
export { Triangle };
//# sourceMappingURL=Triangle.js.map