import { __extends } from "tslib";
import { Layout, eachChildren } from "./Layout";
import * as $type from "../util/Type";
import { Percent } from "../util/Percent";
/**
 * A vertical children layout for [[Container]].
 *
 * @see {@link https://www.amcharts.com/docs/v5/concepts/common-elements/containers/#Layout} for more info
 */
var VerticalLayout = /** @class */ (function (_super) {
    __extends(VerticalLayout, _super);
    function VerticalLayout() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * @ignore
     */
    Object.defineProperty(VerticalLayout.prototype, "updateContainer", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (container) {
            var paddingTop = container.get("paddingTop", 0);
            var availableHeight = container.innerHeight();
            var totalPercent = 0;
            eachChildren(container, function (child) {
                if (child.get("position") == "relative") {
                    var childHeight = child.get("height");
                    if (childHeight instanceof Percent) {
                        totalPercent += childHeight.value;
                        var h = availableHeight * childHeight.value;
                        var minHeight = child.get("minHeight", -Infinity);
                        if (minHeight > h) {
                            availableHeight -= minHeight;
                            totalPercent -= childHeight.value;
                        }
                        var maxHeight = child.get("minHeight", Infinity);
                        if (h > maxHeight) {
                            availableHeight -= maxHeight;
                            totalPercent -= childHeight.value;
                        }
                    }
                    else {
                        if (!$type.isNumber(childHeight)) {
                            childHeight = child.height();
                        }
                        availableHeight -= childHeight + child.get("marginTop", 0) + child.get("marginBottom", 0);
                    }
                }
            });
            if (availableHeight > 0) {
                eachChildren(container, function (child) {
                    if (child.get("position") == "relative") {
                        var childHeight = child.get("height");
                        if (childHeight instanceof Percent) {
                            var privateHeight = availableHeight * childHeight.value / totalPercent - child.get("marginTop", 0) - child.get("marginBottom", 0);
                            var minHeight = child.get("minHeight", -Infinity);
                            var maxHeight = child.get("maxHeight", Infinity);
                            privateHeight = Math.min(Math.max(minHeight, privateHeight), maxHeight);
                            child.setPrivate("height", privateHeight);
                        }
                    }
                });
            }
            var prevY = paddingTop;
            eachChildren(container, function (child) {
                if (child.get("position") == "relative") {
                    var bounds = child.adjustedLocalBounds();
                    var marginTop = child.get("marginTop", 0);
                    var marginBottom = child.get("marginBottom", 0);
                    var y = prevY + marginTop - bounds.top;
                    child.setPrivate("y", y);
                    prevY = y + bounds.bottom + marginBottom;
                }
            });
        }
    });
    Object.defineProperty(VerticalLayout, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "VerticalLayout"
    });
    Object.defineProperty(VerticalLayout, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Layout.classNames.concat([VerticalLayout.className])
    });
    return VerticalLayout;
}(Layout));
export { VerticalLayout };
//# sourceMappingURL=VerticalLayout.js.map