import { __extends } from "tslib";
import { Gradient } from "./Gradient";
import { Color } from "../../util/Color";
import * as $array from "../../util/Array";
import * as $type from "../../util/Type";
/**
 * Radial gradient.
 *
 * @see {@link https://www.amcharts.com/docs/v5/concepts/colors-gradients-and-patterns/gradients/} for more info
 */
var RadialGradient = /** @class */ (function (_super) {
    __extends(RadialGradient, _super);
    function RadialGradient() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * @ignore
     */
    Object.defineProperty(RadialGradient.prototype, "getFill", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function (target) {
            var bounds = this.getBounds(target);
            var x = 0;
            var y = 0;
            var l = bounds.left || 0;
            var r = bounds.right || 0;
            var t = bounds.top || 0;
            var b = bounds.bottom || 0;
            var width = r - l;
            var height = b - t;
            var radius = target.get("radius");
            if ($type.isNumber(radius)) {
                x = 0;
                y = 0;
            }
            else {
                radius = Math.min(width, height) / 2;
                x = width / 2;
                y = height / 2;
            }
            var gradient = this._root._renderer.createRadialGradient(x, y, 0, x, y, radius);
            var stops = this.get("stops");
            if (stops) {
                var i_1 = 0;
                $array.each(stops, function (stop) {
                    var offset = stop.offset;
                    if (!$type.isNumber(offset)) {
                        offset = i_1 / (stops.length - 1);
                    }
                    var opacity = stop.opacity;
                    if (!$type.isNumber(opacity)) {
                        opacity = 1;
                    }
                    var color = stop.color;
                    if (color) {
                        var lighten = stop.lighten;
                        if (lighten) {
                            color = Color.lighten(color, lighten);
                        }
                        var brighten = stop.brighten;
                        if (brighten) {
                            color = Color.brighten(color, brighten);
                        }
                        gradient.addColorStop(offset, 'rgba(' + color.r + ',' + color.g + ',' + color.b + ',' + opacity + ')');
                    }
                    i_1++;
                });
            }
            return gradient;
        }
    });
    Object.defineProperty(RadialGradient, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "RadialGradient"
    });
    Object.defineProperty(RadialGradient, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Gradient.classNames.concat([RadialGradient.className])
    });
    return RadialGradient;
}(Gradient));
export { RadialGradient };
//# sourceMappingURL=RadialGradient.js.map