import { __extends } from "tslib";
import { Pattern } from "./Pattern";
import * as $math from "../../util/Math";
/**
 * Circle pattern.
 *
 * @see {@link https://www.amcharts.com/docs/v5/concepts/colors-gradients-and-patterns/patterns/} for more info
 */
var CirclePattern = /** @class */ (function (_super) {
    __extends(CirclePattern, _super);
    function CirclePattern() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(CirclePattern.prototype, "_beforeChanged", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._beforeChanged.call(this);
            if (this.isDirty("gap")) {
                this._clear = true;
            }
        }
    });
    Object.defineProperty(CirclePattern.prototype, "_draw", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._draw.call(this);
            var checkered = this.get("checkered", false);
            var centered = this.get("centered", true);
            var gap = this.get("gap", 0);
            var rotation = this.get("rotation", 0);
            var w = this.get("width", 100);
            var h = this.get("height", 100);
            var radius = this.get("radius", 3);
            var cellW = radius * 2 + gap;
            var cellH = radius * 2 + gap;
            var cols = Math.round(w / cellW);
            var rows = Math.round(h / cellH);
            cellW = w / cols;
            cellH = h / rows;
            if (rotation != 0) {
                // @todo this is probably not right
                this._display.x = cellW * $math.cos(rotation);
                this._display.y = cellH * $math.sin(rotation);
            }
            var color = this.get("color");
            var colorOpacity = this.get("colorOpacity");
            if (color || colorOpacity) {
                this._display.beginFill(color, colorOpacity);
            }
            for (var r = rotation == 0 ? 0 : -rows * 2; r < rows * 2; r++) {
                for (var c = rotation == 0 ? 0 : -cols * 2; c < cols * 2; c++) {
                    if (!checkered || ((r & 1) != 1 && (c & 1) != 1) || ((r & 1) == 1 && (c & 1) == 1)) {
                        var x = c * cellW;
                        var y = r * cellH;
                        if (centered) {
                            x += cellW + gap / 2;
                            y += cellH + gap / 2;
                        }
                        this._display.drawCircle(x - radius, y - radius, radius);
                    }
                }
            }
            if (checkered) {
                w = w / 2 - gap * 2;
                h = h / 2 - gap * 2;
            }
            else {
                w -= gap;
                h -= gap;
            }
            if (color || colorOpacity) {
                this._display.endFill();
            }
        }
    });
    Object.defineProperty(CirclePattern, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "CirclePattern"
    });
    Object.defineProperty(CirclePattern, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Pattern.classNames.concat([CirclePattern.className])
    });
    return CirclePattern;
}(Pattern));
export { CirclePattern };
//# sourceMappingURL=CirclePattern.js.map