import { __extends } from "tslib";
import { Pattern } from "./Pattern";
import * as $type from "../../util//Type";
/**
 * Line pattern.
 *
 * @see {@link https://www.amcharts.com/docs/v5/concepts/colors-gradients-and-patterns/patterns/} for more info
 */
var LinePattern = /** @class */ (function (_super) {
    __extends(LinePattern, _super);
    function LinePattern() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(LinePattern.prototype, "_beforeChanged", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._beforeChanged.call(this);
            if (this.isDirty("gap")) {
                this._clear = true;
            }
        }
    });
    Object.defineProperty(LinePattern.prototype, "_draw", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._draw.call(this);
            var w = this.get("width", 100);
            var h = this.get("height", 100);
            var gap = this.get("gap", 0);
            var strokeWidth = this.get("strokeWidth", 1);
            if (!gap) {
                this._display.moveTo(0, 0);
                this._display.lineTo(w, 0);
            }
            else {
                var step = gap + strokeWidth;
                var count = h / step;
                for (var i = -count; i < count * 2; i++) {
                    var y = Math.round(i * step - step / 2) + 0.5;
                    this._display.moveTo(-w, y);
                    this._display.lineTo(w * 2, y);
                }
            }
            this._display.lineStyle(strokeWidth, this.get("color"), this.get("colorOpacity"));
            var strokeDasharray = this.get("strokeDasharray");
            if ($type.isNumber(strokeDasharray)) {
                if (strokeDasharray < 0.5) {
                    strokeDasharray = [0];
                }
                else {
                    strokeDasharray = [strokeDasharray];
                }
            }
            this._display.setLineDash(strokeDasharray);
            var strokeDashoffset = this.get("strokeDashoffset");
            if (strokeDashoffset) {
                this._display.setLineDashOffset(strokeDashoffset);
            }
            this._display.endStroke();
        }
    });
    Object.defineProperty(LinePattern, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "LinePattern"
    });
    Object.defineProperty(LinePattern, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Pattern.classNames.concat([LinePattern.className])
    });
    return LinePattern;
}(Pattern));
export { LinePattern };
//# sourceMappingURL=LinePattern.js.map