import { __extends } from "tslib";
import { Entity } from "../../util/Entity";
/**
 * Base class for patterns.
 *
 * @see {@link https://www.amcharts.com/docs/v5/concepts/colors-gradients-and-patterns/patterns/} for more info
 */
var Pattern = /** @class */ (function (_super) {
    __extends(Pattern, _super);
    function Pattern() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        Object.defineProperty(_this, "_display", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: _this._root._renderer.makeGraphics()
        });
        Object.defineProperty(_this, "_backgroundDisplay", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: _this._root._renderer.makeGraphics()
        });
        Object.defineProperty(_this, "_clear", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: false
        });
        Object.defineProperty(_this, "_pattern", {
            enumerable: true,
            configurable: true,
            writable: true,
            value: void 0
        });
        return _this;
    }
    Object.defineProperty(Pattern.prototype, "_afterNew", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            // Applying themes because pattern will not have parent
            _super.prototype._afterNewApplyThemes.call(this);
        }
    });
    Object.defineProperty(Pattern.prototype, "pattern", {
        get: function () {
            return this._pattern;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Pattern.prototype, "_draw", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () { }
    });
    Object.defineProperty(Pattern.prototype, "_beforeChanged", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._beforeChanged.call(this);
            if (this.isDirty("repetition") || this.isDirty("width") || this.isDirty("height") || this.isDirty("rotation") || this.isDirty("color") || this.isDirty("strokeWidth") || this.isDirty("strokeDasharray") || this.isDirty("strokeDashoffset") || this.isDirty("colorOpacity") || this.isDirty("fill") || this.isDirty("fillOpacity")) {
                this._clear = true;
            }
        }
    });
    Object.defineProperty(Pattern.prototype, "_changed", {
        enumerable: false,
        configurable: true,
        writable: true,
        value: function () {
            _super.prototype._changed.call(this);
            if (this._clear) {
                var repetition = this.get("repetition", "");
                var width = this.get("width", 100);
                var height = this.get("height", 100);
                var fill = this.get("fill");
                var fillOpacity = this.get("fillOpacity", 1);
                this._display.clear();
                this._backgroundDisplay.clear();
                if (fill && (fillOpacity > 0)) {
                    this._backgroundDisplay.beginFill(fill, fillOpacity);
                    this._backgroundDisplay.drawRect(0, 0, width, height);
                    this._backgroundDisplay.endFill();
                }
                this._display.angle = this.get("rotation", 0);
                //this._display.pivot = { x: width / 2, y: height / 2 };
                this._draw();
                this._pattern = this._root._renderer.createPattern(this._display, this._backgroundDisplay, repetition, width, height);
            }
        }
    });
    Object.defineProperty(Pattern, "className", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: "Pattern"
    });
    Object.defineProperty(Pattern, "classNames", {
        enumerable: true,
        configurable: true,
        writable: true,
        value: Entity.classNames.concat([Pattern.className])
    });
    return Pattern;
}(Entity));
export { Pattern };
//# sourceMappingURL=Pattern.js.map